"use strict";
/*
Copyright 2019 The Matrix.org Foundation C.I.C.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BridgeRequestErr = exports.BridgeRequest = void 0;
const logging_1 = require("../logging");
const Sentry = __importStar(require("@sentry/node"));
const log = (0, logging_1.getLogger)("req");
class BridgeRequest {
    req;
    log;
    constructor(req) {
        this.req = req;
        const isFromIrc = req.getData() ? Boolean(req.getData()?.isFromIrc) : false;
        this.log = (0, logging_1.newRequestLogger)(log, req.getId(), isFromIrc);
    }
    getId() {
        return this.req.getId();
    }
    getPromise() {
        return this.req.getPromise();
    }
    resolve(thing) {
        this.req.resolve(thing);
    }
    reject(err) {
        this.req.reject(err);
    }
    static HandleExceptionForSentry(req, state) {
        const reqData = req.getData() || {};
        req.getPromise().catch((ex) => {
            Sentry.withScope((scope) => {
                if (reqData.event_id) {
                    scope.setExtra("event_id", reqData.event_id);
                }
                if (reqData.room_id) {
                    scope.setTag("room_id", reqData.room_id);
                }
                if (reqData.type) {
                    scope.setTag("type", reqData.type);
                }
                if (reqData.isFromIrc !== undefined) {
                    scope.setTag("from", reqData.isFromIrc ? "irc" : "matrix");
                }
                scope.setTag("state", state);
                Sentry.captureException(ex);
            });
        });
    }
}
exports.BridgeRequest = BridgeRequest;
var BridgeRequestErr;
(function (BridgeRequestErr) {
    BridgeRequestErr[BridgeRequestErr["ERR_VIRTUAL_USER"] = 0] = "ERR_VIRTUAL_USER";
    BridgeRequestErr[BridgeRequestErr["ERR_NOT_MAPPED"] = 1] = "ERR_NOT_MAPPED";
    BridgeRequestErr[BridgeRequestErr["ERR_DROPPED"] = 2] = "ERR_DROPPED";
})(BridgeRequestErr = exports.BridgeRequestErr || (exports.BridgeRequestErr = {}));
//# sourceMappingURL=BridgeRequest.js.map