## See sim/Makefile.am
##
## Copyright (C) 2005-2023 Free Software Foundation, Inc.
## Written by Analog Devices, Inc.
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 3 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program.  If not, see <http://www.gnu.org/licenses/>.

%C%_run_SOURCES =
%C%_run_LDADD = \
	%D%/nrun.o \
	%D%/libsim.a \
	$(SIM_COMMON_LIBS)

noinst_PROGRAMS += %D%/run

%D%/linux-fixed-code.h: @MAINT@ $(srcdir)/%D%/linux-fixed-code.s %D%/local.mk %D%/$(am__dirstamp)
	$(AM_V_GEN)$(AS_FOR_TARGET_BFIN) $(srcdir)/%D%/linux-fixed-code.s -o %D%/linux-fixed-code.o
	$(AM_V_at)(\
		set -e; \
		echo "/* DO NOT EDIT: Autogenerated from linux-fixed-code.s.  */"; \
		echo "static const unsigned char bfin_linux_fixed_code[] ="; \
		echo "{"; \
		$(OBJDUMP_FOR_TARGET_BFIN) -d -z %D%/linux-fixed-code.o > $@.dis; \
		sed -n \
			-e 's:^[^	]*	:0x:' \
			-e '/^0x/{s:	.*::;s: *$$:,:;s: :, 0x:g;p;}' \
			$@.dis; \
		rm -f $@.dis; \
		echo "};" \
	) > $@.tmp
	$(AM_V_at)$(SHELL) $(srcroot)/move-if-change $@.tmp $(srcdir)/%D%/linux-fixed-code.h
	$(AM_V_at)touch $(srcdir)/%D%/linux-fixed-code.h
