# ModulePresentationsForCAP, single 3
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST("modulepresentationsforcap03.tst");

# doc/_Chapter_Examples_and_Tests.xml:83-164
gap> Q := HomalgFieldOfRationalsInSingular();;
gap> R := Q * "x,y,z";;
gap> M := HomalgMatrix( [ [ "x" ], [ "y" ], [ "z" ] ], 3, 1, R );;
gap> Ml := AsLeftPresentation( M );;
gap> eps := CoverByFreeModule( Ml );;
gap> iota1 := KernelEmbedding( eps );;
gap> Display( iota1 );
x,
y,
z 

A monomorphism in Category of left presentations of Q[x,y,z]
gap> Display( Source( iota1 ) );
0, -z,y,
-z,0, x,
-y,x, 0 

An object in Category of left presentations of Q[x,y,z]
gap> pi1 := CoverByFreeModule( Source( iota1 ) );;
gap> d1 := PreCompose( pi1, iota1 );;
gap> Display( d1 );
x,
y,
z 

A morphism in Category of left presentations of Q[x,y,z]
gap> iota2 := KernelEmbedding( d1 );;
gap> Display( iota2 );
0, -z,y,
-z,0, x,
-y,x, 0 

A monomorphism in Category of left presentations of Q[x,y,z]
gap> Display( Source( iota2 ) );;
x,-y,z

An object in Category of left presentations of Q[x,y,z]
gap> pi2 := CoverByFreeModule( Source( iota2 ) );;
gap> d2 := PreCompose( pi2, iota2 );;
gap> Display( d2 );
0, -z,y,
-z,0, x,
-y,x, 0 

A morphism in Category of left presentations of Q[x,y,z]
gap> iota3 := KernelEmbedding( d2 );;
gap> Display( iota3 );
x,-y,z

A monomorphism in Category of left presentations of Q[x,y,z]
gap> Display( Source( iota3 ) );
(an empty 0 x 1 matrix)

An object in Category of left presentations of Q[x,y,z]
gap> pi3 := CoverByFreeModule( Source( iota3 ) );;
gap> d3 := PreCompose( pi3, iota3 );;
gap> Display( d3 );
x,-y,z

A morphism in Category of left presentations of Q[x,y,z]
gap> N := HomalgMatrix( [ [ "x" ] ], 1, 1, R );;
gap> Nl := AsLeftPresentation( N );;
gap> d2Nl := TensorProductOnMorphisms( d2, IdentityMorphism( Nl ) );;
gap> d1Nl := TensorProductOnMorphisms( d1, IdentityMorphism( Nl ) );;
gap> IsZero( PreCompose( d2Nl, d1Nl ) );
true
gap> cycles := KernelEmbedding( d1Nl );;
gap> boundaries := ImageEmbedding( d2Nl );;
gap> boundaries_in_cyles := LiftAlongMonomorphism( cycles, boundaries );;
gap> homology := CokernelObject( boundaries_in_cyles );;
gap> LessGenFunctor := FunctorLessGeneratorsLeft( R );;
gap> homology := ApplyFunctor( LessGenFunctor, homology );;
gap> StdBasisFunctor := FunctorStandardModuleLeft( R );;
gap> homology := ApplyFunctor( StdBasisFunctor, homology );;
gap> Display( homology );
z,
y,
x 

An object in Category of left presentations of Q[x,y,z]

#
gap> STOP_TEST("modulepresentationsforcap03.tst", 1);
