/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.hover;

import javax.swing.SwingUtilities;
import net.infonode.gui.hover.HoverEvent;
import net.infonode.gui.hover.HoverListener;
import net.infonode.gui.hover.action.DelayedHoverExitAction;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.tabbedpanel.hover.TitledTabHoverAction;
import net.infonode.tabbedpanel.titledtab.TitledTab;
import net.infonode.tabbedpanel.titledtab.TitledTabProperties;

public class TitledTabDelayedMouseExitHoverAction
implements HoverListener {
    private DelayedHoverExitAction delayedAction;
    private HoverListener hoverListener;

    public TitledTabDelayedMouseExitHoverAction(int delay, HoverListener hoverListener) {
        this.hoverListener = hoverListener;
        this.delayedAction = new DelayedHoverExitAction(new HoverListener(){

            @Override
            public void mouseEntered(HoverEvent event) {
                TitledTabDelayedMouseExitHoverAction.this.getHoverListener().mouseEntered(event);
            }

            @Override
            public void mouseExited(HoverEvent event) {
                TitledTabDelayedMouseExitHoverAction.this.getHoverListener().mouseExited(event);
            }
        }, delay);
    }

    public HoverListener getHoverListener() {
        return this.hoverListener;
    }

    public TitledTabProperties getTitledTabProperties() {
        if (this.getHoverListener() instanceof TitledTabHoverAction) {
            return ((TitledTabHoverAction)this.getHoverListener()).getTitledTabProperties();
        }
        return null;
    }

    @Override
    public void mouseEntered(HoverEvent event) {
        this.delayedAction.mouseEntered(event);
    }

    @Override
    public void mouseExited(HoverEvent event) {
        final TitledTab tab = (TitledTab)event.getSource();
        final TabbedPanel tp = tab.getTabbedPanel();
        this.delayedAction.mouseExited(event);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (tab.getTabbedPanel() != tp) {
                    TitledTabDelayedMouseExitHoverAction.this.delayedAction.forceExit(tab);
                }
            }
        });
    }
}

