/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer;

import com.tngtech.archunit.ArchConfiguration;
import java.awt.Component;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.IUserInputListenerFactory;
import org.freeplane.core.ui.components.FreeplaneToolBar;
import org.freeplane.core.ui.components.resizer.UIComponentVisibilityDispatcher;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.core.ui.menubuilders.generic.PhaseProcessor;
import org.freeplane.core.ui.menubuilders.menu.ComponentProvider;
import org.freeplane.core.ui.menubuilders.menu.JToolbarComponentBuilder;
import org.freeplane.features.attribute.AttributeController;
import org.freeplane.features.clipboard.ClipboardControllers;
import org.freeplane.features.cloud.CloudController;
import org.freeplane.features.edge.EdgeController;
import org.freeplane.features.export.mindmapmode.ExportController;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.layout.LayoutController;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.FoldingController;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mapio.MapIO;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.IPropertyHandler;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodelocation.LocationController;
import org.freeplane.features.nodestyle.NodeGeometryModel;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyle;
import org.freeplane.features.text.TextController;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.features.url.UrlManager;
import org.freeplane.main.application.ApplicationResourceController;
import org.freeplane.main.application.LastOpenedList;
import org.freeplane.plugin.codeexplorer.CodeIconController;
import org.freeplane.plugin.codeexplorer.CodeLayoutController;
import org.freeplane.plugin.codeexplorer.CodeModeController;
import org.freeplane.plugin.codeexplorer.connectors.CodeLinkController;
import org.freeplane.plugin.codeexplorer.map.CodeMapController;
import org.freeplane.view.swing.features.nodehistory.NodeHistory;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.ui.UserInputListenerFactory;

public class CodeModeControllerFactory {
    private static CodeModeController modeController;

    public static CodeModeController createModeController() {
        ((ApplicationResourceController)ResourceController.getResourceController()).registerResourceLoader(CodeModeController.class.getClassLoader());
        ArchConfiguration.get().setResolveMissingDependenciesFromClassPath(false);
        final Controller controller = Controller.getCurrentController();
        modeController = new CodeModeController(controller);
        UserInputListenerFactory userInputListenerFactory = new UserInputListenerFactory((ModeController)modeController);
        modeController.setUserInputListenerFactory((IUserInputListenerFactory)userInputListenerFactory);
        controller.addModeController((ModeController)modeController);
        controller.selectModeForBuild((ModeController)modeController);
        ClipboardControllers.install((ClipboardControllers)new ClipboardControllers());
        new CodeMapController(modeController);
        UrlManager.install((UrlManager)new UrlManager());
        MapIO.install((ModeController)modeController);
        new CodeIconController(modeController).install(modeController);
        AttributeController.install((AttributeController)new AttributeController((ModeController)modeController));
        NodeStyleController.install((NodeStyleController)new NodeStyleController((ModeController)modeController));
        EdgeController.install((EdgeController)new EdgeController((ModeController)modeController));
        new TextController((ModeController)modeController).install((ModeController)modeController);
        FoldingController.install((FoldingController)new FoldingController());
        LinkController.install((LinkController)new CodeLinkController(modeController));
        CloudController.install((CloudController)new CloudController((ModeController)modeController));
        LocationController.install((LocationController)new LocationController());
        LayoutController.install((LayoutController)new CodeLayoutController());
        LogicalStyleController.install((LogicalStyleController)new LogicalStyleController((ModeController)modeController));
        ExportController.install((ExportController)new ExportController("/xml/ExportWithXSLT.xml"));
        MapStyle.install((boolean)true);
        NodeStyleController.getController().shapeHandlers.addGetter(new Integer(0), (IPropertyHandler)new IPropertyHandler<NodeGeometryModel, NodeModel>(){

            public NodeGeometryModel getProperty(NodeModel node, LogicalStyleController.StyleOption option, NodeGeometryModel currentValue) {
                return NodeGeometryModel.FORK;
            }
        });
        userInputListenerFactory.setNodePopupMenu(new JPopupMenu());
        FreeplaneToolBar toolBar = new FreeplaneToolBar("main_toolbar", 0);
        UIComponentVisibilityDispatcher.install((JComponent)toolBar, (String)"toolbarVisible");
        userInputListenerFactory.addToolBar("/main_toolbar", 0, (JComponent)toolBar);
        userInputListenerFactory.addToolBar("/filter_toolbar", FilterController.TOOLBAR_SIDE, FilterController.getCurrentFilterController().getFilterToolbar());
        userInputListenerFactory.addToolBar("/status", 3, controller.getViewController().getStatusBar());
        modeController.addUiBuilder(PhaseProcessor.Phase.UI, "main_toolbar_zoom", (EntryVisitor)new JToolbarComponentBuilder(new ComponentProvider(){

            public Component createComponent(Entry entry) {
                return controller.getMapViewManager().createZoomBox();
            }
        }));
        NodeHistory.install((ModeController)modeController);
        controller.getMapViewManager().addMapViewChangeListener(new IMapViewChangeListener(){

            public void afterViewCreated(Component oldView, Component newView) {
                ((MapView)newView).setRepaintsViewOnSelectionChange(true);
            }
        });
        LastOpenedList lastOpenedList = ((ApplicationResourceController)ResourceController.getResourceController()).getLastOpenedList();
        modeController.getMapController().addUIMapChangeListener((IMapChangeListener)lastOpenedList);
        lastOpenedList.registerMenuContributor((ModeController)modeController);
        controller.selectModeForBuild((ModeController)modeController);
        modeController.updateMenus("/xml/codeexplorermodemenu.xml", Collections.singleton(""));
        controller.selectModeForBuild(null);
        return modeController;
    }
}

