#
# Completions for Cdrecord
#

complete -c cdrecord -o version -d "Display version"
complete -c cdrecord -s v -d "Increment the level of general verbosity by one"
complete -c cdrecord -s V -d "Increment the verbose level in respect of SCSI command transport by one"
complete -c cdrecord -a "debug={1,2,3,4,5}" -d "Set the misc debug value to #"
complete -c cdrecord -s d -d "Increment the misc debug level by one" -a "1 2 3 4 5"
complete -c cdrecord -s s -o silent -d "Do not print out a status report for failed SCSI commands"
complete -c cdrecord -o force -d "Force to continue on some errors"
complete -c cdrecord -o immed -d "Set the SCSI IMMED flag in certain commands"
complete -c cdrecord -a "minbuf={25,35,45,55,65,75,85,95}" -d "Minimum drive buffer fill ratio for the ATAPI wait mode"
complete -c cdrecord -o dummy -d "Complete CD/DVD-Recorder recording process with the laser turned off"
complete -c cdrecord -o clone -d "Handle images created by readcd -clone"
complete -c cdrecord -o dao
complete -c cdrecord -o sao -d "Set SAO (Session At Once) mode, usually called Disk At Once mode"
complete -c cdrecord -o tao -d "Set TAO (Track At Once) writing mode"
complete -c cdrecord -o raw -d "Set RAW writing mode"
complete -c cdrecord -o raw96r -d "Select Set RAW writing, the preferred raw writing mode"
complete -c cdrecord -o raw96p -d "Select Set RAW writing, the less preferred raw writing mode"
complete -c cdrecord -o raw16 -d "Select Set RAW writing, the preferred raw writing mode after raw96r"
complete -c cdrecord -o multi -d "Allow multi session CDs to be made"
complete -c cdrecord -o msinfo -d "Retrieve multi session info in a form suitable for mkisofs-1.10 or later"
complete -c cdrecord -o toc -d "Retrieve and print out the table of content or PMA of a CD"
complete -c cdrecord -o atip -d "Retrieve and print out the ATIP (absolute Time in Pre-groove) info"
complete -c cdrecord -o fix -d "Only fixate disk "
complete -c cdrecord -o nofix -d "Do not fixate the disk after writing the tracks"
complete -c cdrecord -o waiti -d "Wait for standard input to become available before opening the SCSI driver"
complete -c cdrecord -o load -d "Load the media"
complete -c cdrecord -o lock -d "Load the media, lock the door"
complete -c cdrecord -o eject -d "Eject disk after doing the work"
complete -c cdrecord -a "speed={0,150,172,1385}" -d "Set the speed factor of the writing process to #"
complete -c cdrecord -a "blank={help,all,fast,track,unreserve,trtail,unclose,session}" -d "Blank a CD-RW and exit or blank a CD-RW before writing"
complete -c cdrecord -o format -d "Format a CD-RW/DVD-RW/DVD+RW disc"
complete -c cdrecord -a "fs=" -d "Set the FIFO (ring buffer) size to #"
complete -c cdrecord -a "ts=" -d "Set the maximum transfer size for a single SCSI command to #"
complete -c cdrecord -a "dev=" -d "Sets the SCSI target for the CD/DVD-Recorder"
complete -c cdrecord -a "gracetime=" -d "Set the grace time before starting to write to ># seconds"
complete -c cdrecord -a "timeout=" -d "Set the default SCSI command timeout value to # seconds"
complete -c cdrecord -a "driver={help,mmc_cd,mmc_cd_dvd,mmc_cdr,mmc_cdr_sony,mmc_dvd,mmc_dvdplus,mmc_dvdplusr,mmc_dvdplusrw,cw_7501,kodak_pcd_600,philips_cdd521,philips_cdd521_old,philips_cdd522,philips_dumb,pioneer_dws114x,plasmon_rf4100,ricoh_ro1060c,ricoh_ro1420c,scsi2_cd,sony_cdu924,teac_cdr50,tyuden_ew50,yamaha_cdr100,cdr_simul,dvd_simul}" -d "Allows the user to manually select a driver for the device"

# TODO: This argument accepts a comma separated list of arguments

complete -c cdrecord -a "driveropts=" -d "Set driver specific options"
complete -c cdrecord -o setdropts -d "Set driver specific options"
complete -c cdrecord -o checkdrive -d "Checks if a driver for the current drive is present"
complete -c cdrecord -o prcap -d "Print the drive capabilities for SCSI-3/mmc compliant drives"
complete -c cdrecord -o inq -d "Do an inquiry for the drive, print the inquiry info"
complete -c cdrecord -o scanbus -d "Scan all SCSI devices on all SCSI busses and print the inquiry strings"
complete -c cdrecord -o reset -d "Try to reset the SCSI bus where the CD recorder is located"
complete -c cdrecord -o abort -d "Try to send an abort sequence to the drive"
complete -c cdrecord -o overburn -d "Allow writing more than the official size of a medium"
complete -c cdrecord -o ignsize -d "Ignore the known size of the medium, use for debugging only"
complete -c cdrecord -o useinfo -d "Use *.inf files to overwrite audio options"
complete -c cdrecord -a "defpregap=" -d "Set default pre-gap size for all tracks except track nr 1"
complete -c cdrecord -o packet -d "Set Packet writing mode"
complete -c cdrecord -a "pktsize=" -d "Set the packet size to #, forces fixed packet mode"
complete -c cdrecord -o noclose -d "Don't close the current track, only when in packet writing mode"
complete -c cdrecord -a "mcn=" -d "Set the Media Catalog Number of the CD"
complete -c cdrecord -o text -d "Write CD-Text info based on file containing ascii info"
complete -c cdrecord -a "textfile=" -d "Write CD-Text based on info found in the binary file filename"
complete -c cdrecord -a "cuefile=" -d "Take all recording related info from a CDRWIN compliant CUE sheet file"

# These completions are TRACK OPTIONS

complete -c cdrecord -a "isrc=" -d "Set the International Standard Recording Number for the next track"
complete -c cdrecord -a "index=" -d "Sets an index list for the next track"
complete -c cdrecord -o audio -d "Subsequent tracks are written in CD-DA format"
complete -c cdrecord -o swab -d "Audio data is assumed to be in byte-swapped order"
complete -c cdrecord -o data -d "Subsequent tracks are written in CD-ROM mode 1 format"
complete -c cdrecord -o mode2 -d "Subsequent tracks are written in CD-ROM mode 2 format"
complete -c cdrecord -o xa -d "Subsequent tracks are written in CD-ROM XA mode 2 form 1 format"
complete -c cdrecord -o xa1 -d "Subsequent tracks are written in CD-ROM XA mode 2 form 1 format"
complete -c cdrecord -o xa2 -d "Subsequent tracks are written in CD-ROM XA mode 2 form 2 format"
complete -c cdrecord -o xamix -d "Subsequent tracks allows a mix of CD-ROM XA mode 2 form 1/2 format"
complete -c cdrecord -o cdi -d "The TOC type for the disk is set to CDI, with XA only"
complete -c cdrecord -o isosize -d "Use the ISO-9660 file system size as the size of the next track"
complete -c cdrecord -o pad -d "Add 15 sectors of zeroed data to the end of this and subsequent tracks"
complete -c cdrecord -a "padsize=" -d "Set the amount of data to be appended as padding to the next track"
complete -c cdrecord -o nopad -d "Do not pad the following tracks - the default"
complete -c cdrecord -o shorttrack -d "Allow all subsequent tracks to violate the Red Book track length standard"
complete -c cdrecord -o noshorttrack -d "Re-enforce the Red Book track length standard"
complete -c cdrecord -a "pregap=" -d "Set the pre-gap size for the next track"
complete -c cdrecord -o preemp -d "TOC indicates that data has been sampled with 50/15 microsec pre-emphasis"
complete -c cdrecord -o nopreemp -d "TOC indicates that data has been mastered with linear data"
complete -c cdrecord -o copy -d "TOC indicates that data has permission to be copied without limit"
complete -c cdrecord -o nocopy -d "TOC indicates that data has permission to be copied only once"
complete -c cdrecord -o scms -d "TOC indicates that data has no permission to be copied"
complete -c cdrecord -a "tsize=" -d "Specify valid amount of data on raw disk for next track's master image"
