/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FakedTrackingVariable;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SubRoutineStatement;
import org.eclipse.jdt.internal.compiler.ast.SwitchExpression;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.UnionTypeReference;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.codegen.ExceptionLabel;
import org.eclipse.jdt.internal.compiler.codegen.MultiCatchExceptionLabel;
import org.eclipse.jdt.internal.compiler.codegen.StackMapFrameCodeStream;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FinallyFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InsideSubRoutineFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class TryStatement
extends SubRoutineStatement {
    static final char[] SECRET_RETURN_ADDRESS_NAME = " returnAddress".toCharArray();
    static final char[] SECRET_ANY_HANDLER_NAME = " anyExceptionHandler".toCharArray();
    static final char[] SECRET_PRIMARY_EXCEPTION_VARIABLE_NAME = " primaryException".toCharArray();
    static final char[] SECRET_CAUGHT_THROWABLE_VARIABLE_NAME = " caughtThrowable".toCharArray();
    static final char[] SECRET_RETURN_VALUE_NAME = " returnValue".toCharArray();
    public Statement[] resources = new Statement[0];
    public Block tryBlock;
    public Block[] catchBlocks;
    public Argument[] catchArguments;
    public Block finallyBlock;
    BlockScope scope;
    public UnconditionalFlowInfo subRoutineInits;
    ReferenceBinding[] caughtExceptionTypes;
    boolean[] catchExits;
    BranchLabel subRoutineStartLabel;
    public LocalVariableBinding anyExceptionVariable;
    public LocalVariableBinding returnAddressVariable;
    public LocalVariableBinding secretReturnValue;
    ExceptionLabel[] declaredExceptionLabels;
    private Object[] reusableJSRTargets;
    private BranchLabel[] reusableJSRSequenceStartLabels;
    private int[] reusableJSRStateIndexes;
    private int reusableJSRTargetsCount = 0;
    private static final int NO_FINALLY = 0;
    private static final int FINALLY_SUBROUTINE = 1;
    private static final int FINALLY_DOES_NOT_COMPLETE = 2;
    private static final int FINALLY_INLINE = 3;
    int mergedInitStateIndex = -1;
    int preTryInitStateIndex = -1;
    int postTryInitStateIndex = -1;
    int[] postResourcesInitStateIndexes;
    int naturalExitMergeInitStateIndex = -1;
    int[] catchExitInitStateIndexes;
    private LocalVariableBinding primaryExceptionVariable;
    private LocalVariableBinding caughtThrowableVariable;
    private ExceptionLabel[] resourceExceptionLabels;
    private int[] caughtExceptionsCatchBlocks;
    public SwitchExpression enclosingSwitchExpression = null;

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        Object object;
        int n;
        FlowInfo flowInfo2;
        int n2;
        this.preTryInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo);
        if (this.anyExceptionVariable != null) {
            this.anyExceptionVariable.useFlag = 1;
        }
        if (this.primaryExceptionVariable != null) {
            this.primaryExceptionVariable.useFlag = 1;
        }
        if (this.caughtThrowableVariable != null) {
            this.caughtThrowableVariable.useFlag = 1;
        }
        if (this.returnAddressVariable != null) {
            this.returnAddressVariable.useFlag = 1;
        }
        if ((n2 = this.resources.length) > 0) {
            this.postResourcesInitStateIndexes = new int[n2];
        }
        if (this.subRoutineStartLabel == null) {
            Object object2;
            int n3;
            FlowContext flowContext2;
            if (flowContext instanceof FinallyFlowContext) {
                flowContext2 = (FinallyFlowContext)flowContext;
                ((FinallyFlowContext)flowContext2).outerTryContext = ((FinallyFlowContext)flowContext2).tryContext;
            }
            flowContext2 = new ExceptionHandlingFlowContext(flowContext, this, this.caughtExceptionTypes, this.caughtExceptionsCatchBlocks, null, this.scope, flowInfo);
            ((ExceptionHandlingFlowContext)flowContext2).conditionalLevel = 0;
            FlowInfo flowInfo3 = flowInfo.copy();
            for (n3 = 0; n3 < n2; ++n3) {
                MethodBinding methodBinding;
                Statement statement = this.resources[n3];
                flowInfo3 = statement.analyseCode(blockScope, flowContext2, flowInfo3);
                this.postResourcesInitStateIndexes[n3] = blockScope.methodScope().recordInitializationStates(flowInfo3);
                object2 = null;
                LocalVariableBinding localVariableBinding = null;
                if (statement instanceof LocalDeclaration) {
                    localVariableBinding = ((LocalDeclaration)statement).binding;
                    object2 = localVariableBinding.type;
                    if (localVariableBinding.closeTracker != null) {
                        localVariableBinding.closeTracker.withdraw();
                        localVariableBinding.closeTracker = null;
                    }
                } else {
                    if (statement instanceof NameReference && ((NameReference)statement).binding instanceof LocalVariableBinding) {
                        localVariableBinding = (LocalVariableBinding)((NameReference)statement).binding;
                    }
                    object2 = ((Expression)statement).resolvedType;
                    this.recordCallingClose(blockScope, flowContext, flowInfo3, (Expression)statement);
                }
                if (localVariableBinding != null) {
                    localVariableBinding.useFlag = 1;
                }
                if ((methodBinding = this.findCloseMethod(statement, (TypeBinding)object2)) == null || !methodBinding.isValidBinding() || methodBinding.returnType.id != 6) continue;
                ReferenceBinding[] referenceBindingArray = methodBinding.thrownExceptions;
                int n4 = referenceBindingArray.length;
                for (int i = 0; i < n4; ++i) {
                    flowContext2.checkExceptionHandlers(referenceBindingArray[i], this.resources[n3], flowInfo3, blockScope, true);
                }
            }
            if (!this.tryBlock.isEmptyBlock()) {
                flowInfo3 = this.tryBlock.analyseCode(blockScope, flowContext2, flowInfo3);
                if ((flowInfo3.tagBits & 1) != 0) {
                    this.bits |= 0x20000000;
                }
            }
            if (n2 > 0) {
                this.postTryInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo3);
                for (n3 = 0; n3 < n2; ++n3) {
                    if (!(this.resources[n3] instanceof LocalDeclaration)) continue;
                    flowInfo3.resetAssignmentInfo(((LocalDeclaration)this.resources[n3]).binding);
                }
            }
            ((ExceptionHandlingFlowContext)flowContext2).complainIfUnusedExceptionHandlers(this.scope, this);
            if (this.catchArguments != null) {
                n3 = this.catchBlocks.length;
                this.catchExits = new boolean[n3];
                this.catchExitInitStateIndexes = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    object2 = this.prepareCatchInfo(flowInfo, (ExceptionHandlingFlowContext)flowContext2, flowInfo3, i);
                    ++flowContext.conditionalLevel;
                    object2 = this.catchBlocks[i].analyseCode(blockScope, flowContext, (FlowInfo)object2);
                    --flowContext.conditionalLevel;
                    this.catchExitInitStateIndexes[i] = blockScope.methodScope().recordInitializationStates((FlowInfo)object2);
                    this.catchExits[i] = (((FlowInfo)object2).tagBits & 1) != 0;
                    flowInfo3 = flowInfo3.mergedWith(((FlowInfo)object2).unconditionalInits());
                }
            }
            this.mergedInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo3);
            flowContext.mergeFinallyNullInfo(((ExceptionHandlingFlowContext)flowContext2).initsOnFinally);
            return flowInfo3;
        }
        InsideSubRoutineFlowContext insideSubRoutineFlowContext = new InsideSubRoutineFlowContext(flowContext, this);
        if (flowContext instanceof FinallyFlowContext) {
            insideSubRoutineFlowContext.outerTryContext = ((FinallyFlowContext)flowContext).tryContext;
        }
        ExceptionHandlingFlowContext exceptionHandlingFlowContext = new ExceptionHandlingFlowContext(insideSubRoutineFlowContext, this, this.caughtExceptionTypes, this.caughtExceptionsCatchBlocks, null, this.scope, flowInfo);
        insideSubRoutineFlowContext.initsOnFinally = exceptionHandlingFlowContext.initsOnFinally;
        FinallyFlowContext finallyFlowContext = new FinallyFlowContext(flowContext, (ASTNode)this.finallyBlock, exceptionHandlingFlowContext);
        UnconditionalFlowInfo unconditionalFlowInfo = this.finallyBlock.analyseCode(blockScope, finallyFlowContext, flowInfo.nullInfoLessUnconditionalCopy()).unconditionalInits();
        exceptionHandlingFlowContext.conditionalLevel = 0;
        if (unconditionalFlowInfo == FlowInfo.DEAD_END) {
            this.bits |= 0x4000;
            this.scope.problemReporter().finallyMustCompleteNormally(this.finallyBlock);
        } else {
            this.tryBlock.scope.finallyInfo = flowInfo2 = unconditionalFlowInfo.copy();
            if (this.catchBlocks != null) {
                for (n = 0; n < this.catchBlocks.length; ++n) {
                    this.catchBlocks[n].scope.finallyInfo = flowInfo2;
                }
            }
        }
        this.subRoutineInits = unconditionalFlowInfo;
        flowInfo2 = flowInfo.copy();
        for (n = 0; n < n2; ++n) {
            MethodBinding methodBinding;
            Statement statement = this.resources[n];
            flowInfo2 = statement.analyseCode(blockScope, exceptionHandlingFlowContext, flowInfo2);
            this.postResourcesInitStateIndexes[n] = blockScope.methodScope().recordInitializationStates(flowInfo2);
            object = null;
            LocalVariableBinding localVariableBinding = null;
            if (statement instanceof LocalDeclaration) {
                localVariableBinding = ((LocalDeclaration)this.resources[n]).binding;
                object = localVariableBinding.type;
                if (localVariableBinding.closeTracker != null) {
                    localVariableBinding.closeTracker.withdraw();
                }
            } else {
                if (statement instanceof NameReference && ((NameReference)statement).binding instanceof LocalVariableBinding) {
                    localVariableBinding = (LocalVariableBinding)((NameReference)statement).binding;
                }
                this.recordCallingClose(blockScope, flowContext, flowInfo2, (Expression)statement);
                object = ((Expression)statement).resolvedType;
            }
            if (localVariableBinding != null) {
                localVariableBinding.useFlag = 1;
            }
            if ((methodBinding = this.findCloseMethod(statement, (TypeBinding)object)) == null || !methodBinding.isValidBinding() || methodBinding.returnType.id != 6) continue;
            ReferenceBinding[] referenceBindingArray = methodBinding.thrownExceptions;
            int n5 = referenceBindingArray.length;
            for (int i = 0; i < n5; ++i) {
                exceptionHandlingFlowContext.checkExceptionHandlers(referenceBindingArray[i], this.resources[n], flowInfo2, blockScope, true);
            }
        }
        if (!this.tryBlock.isEmptyBlock()) {
            flowInfo2 = this.tryBlock.analyseCode(blockScope, exceptionHandlingFlowContext, flowInfo2);
            if ((flowInfo2.tagBits & 1) != 0) {
                this.bits |= 0x20000000;
            }
        }
        if (n2 > 0) {
            this.postTryInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo2);
            for (n = 0; n < n2; ++n) {
                if (!(this.resources[n] instanceof LocalDeclaration)) continue;
                flowInfo2.resetAssignmentInfo(((LocalDeclaration)this.resources[n]).binding);
            }
        }
        exceptionHandlingFlowContext.complainIfUnusedExceptionHandlers(this.scope, this);
        if (this.catchArguments != null) {
            n = this.catchBlocks.length;
            this.catchExits = new boolean[n];
            this.catchExitInitStateIndexes = new int[n];
            for (int i = 0; i < n; ++i) {
                object = this.prepareCatchInfo(flowInfo, exceptionHandlingFlowContext, flowInfo2, i);
                insideSubRoutineFlowContext.conditionalLevel = 1;
                object = this.catchBlocks[i].analyseCode(blockScope, insideSubRoutineFlowContext, (FlowInfo)object);
                this.catchExitInitStateIndexes[i] = blockScope.methodScope().recordInitializationStates((FlowInfo)object);
                this.catchExits[i] = (((FlowInfo)object).tagBits & 1) != 0;
                flowInfo2 = flowInfo2.mergedWith(((FlowInfo)object).unconditionalInits());
            }
        }
        finallyFlowContext.complainOnDeferredChecks(((flowInfo2.tagBits & 3) == 0 ? flowInfo.unconditionalCopy().addPotentialInitializationsFrom(flowInfo2).addPotentialInitializationsFrom(insideSubRoutineFlowContext.initsOnReturn) : insideSubRoutineFlowContext.initsOnReturn).addNullInfoFrom(exceptionHandlingFlowContext.initsOnFinally), blockScope);
        flowContext.mergeFinallyNullInfo(exceptionHandlingFlowContext.initsOnFinally);
        this.naturalExitMergeInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo2);
        if (unconditionalFlowInfo == FlowInfo.DEAD_END) {
            this.mergedInitStateIndex = blockScope.methodScope().recordInitializationStates(unconditionalFlowInfo);
            return unconditionalFlowInfo;
        }
        FlowInfo flowInfo4 = flowInfo2.addInitializationsFrom(unconditionalFlowInfo);
        this.mergedInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo4);
        return flowInfo4;
    }

    private void recordCallingClose(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, Expression expression) {
        FakedTrackingVariable fakedTrackingVariable = FakedTrackingVariable.getCloseTrackingVariable(expression, flowInfo, flowContext);
        if (fakedTrackingVariable != null) {
            if (fakedTrackingVariable.methodScope == blockScope.methodScope()) {
                fakedTrackingVariable.markClose(flowInfo, flowContext);
            } else {
                fakedTrackingVariable.markClosedInNestedMethod();
            }
            fakedTrackingVariable.markClosedEffectivelyFinal();
        }
    }

    private MethodBinding findCloseMethod(ASTNode aSTNode, TypeBinding typeBinding) {
        ReferenceBinding referenceBinding;
        MethodBinding methodBinding = null;
        if (typeBinding != null && typeBinding.isValidBinding() && typeBinding instanceof ReferenceBinding && (methodBinding = (referenceBinding = (ReferenceBinding)typeBinding).getExactMethod(ConstantPool.Close, new TypeBinding[0], this.scope.compilationUnitScope())) == null) {
            InvocationSite.EmptyWithAstNode emptyWithAstNode = new InvocationSite.EmptyWithAstNode(aSTNode);
            methodBinding = this.scope.compilationUnitScope().findMethod(referenceBinding, ConstantPool.Close, new TypeBinding[0], emptyWithAstNode, false);
        }
        return methodBinding;
    }

    private FlowInfo prepareCatchInfo(FlowInfo flowInfo, ExceptionHandlingFlowContext exceptionHandlingFlowContext, FlowInfo flowInfo2, int n) {
        Object object;
        FlowInfo flowInfo3;
        if (this.isUncheckedCatchBlock(n)) {
            flowInfo3 = flowInfo.unconditionalCopy().addPotentialInitializationsFrom(exceptionHandlingFlowContext.initsOnException(n)).addPotentialInitializationsFrom(flowInfo2).addPotentialInitializationsFrom(exceptionHandlingFlowContext.initsOnReturn).addNullInfoFrom(exceptionHandlingFlowContext.initsOnFinally);
        } else {
            object = exceptionHandlingFlowContext.initsOnException(n);
            flowInfo3 = flowInfo.nullInfoLessUnconditionalCopy().addPotentialInitializationsFrom((FlowInfo)object).addNullInfoFrom((FlowInfo)object).addPotentialInitializationsFrom(flowInfo2.nullInfoLessUnconditionalCopy()).addPotentialInitializationsFrom(exceptionHandlingFlowContext.initsOnReturn.nullInfoLessUnconditionalCopy());
        }
        object = this.catchArguments[n].binding;
        flowInfo3.markAsDefinitelyAssigned((LocalVariableBinding)object);
        flowInfo3.markAsDefinitelyNonNull((LocalVariableBinding)object);
        if (this.tryBlock.statements == null && this.resources == null) {
            flowInfo3.setReachMode(1);
        }
        return flowInfo3;
    }

    private boolean isUncheckedCatchBlock(int n) {
        if (this.caughtExceptionsCatchBlocks == null) {
            return this.caughtExceptionTypes[n].isUncheckedException(true);
        }
        int n2 = this.caughtExceptionsCatchBlocks.length;
        for (int i = 0; i < n2; ++i) {
            if (this.caughtExceptionsCatchBlocks[i] != n || !this.caughtExceptionTypes[i].isUncheckedException(true)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ExceptionLabel enterAnyExceptionHandler(CodeStream codeStream) {
        if (this.subRoutineStartLabel == null) {
            return null;
        }
        return super.enterAnyExceptionHandler(codeStream);
    }

    @Override
    public void enterDeclaredExceptionHandlers(CodeStream codeStream) {
        int n;
        int n2;
        int n3 = n2 = this.declaredExceptionLabels == null ? 0 : this.declaredExceptionLabels.length;
        for (n = 0; n < n2; ++n) {
            this.declaredExceptionLabels[n].placeStart();
        }
        n = this.resources.length;
        if (n > 0 && this.resourceExceptionLabels != null) {
            for (n2 = n; n2 >= 0; --n2) {
                this.resourceExceptionLabels[n2].placeStart();
            }
        }
    }

    @Override
    public void exitAnyExceptionHandler() {
        if (this.subRoutineStartLabel == null) {
            return;
        }
        super.exitAnyExceptionHandler();
    }

    @Override
    public void exitDeclaredExceptionHandlers(CodeStream codeStream) {
        int n;
        int n2 = n = this.declaredExceptionLabels == null ? 0 : this.declaredExceptionLabels.length;
        for (int i = 0; i < n; ++i) {
            this.declaredExceptionLabels[i].placeEnd();
        }
    }

    private int finallyMode() {
        if (this.subRoutineStartLabel == null) {
            return 0;
        }
        if (this.isSubRoutineEscaping()) {
            return 2;
        }
        if (this.scope.compilerOptions().inlineJsrBytecode) {
            return 3;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        VariableBinding variableBinding;
        Object object;
        Object object2;
        int n;
        ExceptionLabel[] exceptionLabelArray;
        int n2;
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        boolean bl = codeStream instanceof StackMapFrameCodeStream;
        this.anyExceptionLabel = null;
        this.reusableJSRTargets = null;
        this.reusableJSRSequenceStartLabels = null;
        this.reusableJSRTargetsCount = 0;
        int n3 = codeStream.position;
        int n4 = this.finallyMode();
        boolean bl2 = false;
        int n5 = n2 = this.catchArguments == null ? 0 : this.catchArguments.length;
        if (n2 > 0) {
            exceptionLabelArray = new ExceptionLabel[n2];
            for (n = 0; n < n2; ++n) {
                Argument argument = this.catchArguments[n];
                object2 = null;
                if ((argument.binding.tagBits & 0x1000L) != 0L) {
                    object = new MultiCatchExceptionLabel(codeStream, argument.binding.type);
                    ((MultiCatchExceptionLabel)object).initialize((UnionTypeReference)argument.type, argument.annotations);
                    object2 = object;
                } else {
                    object2 = new ExceptionLabel(codeStream, argument.binding.type, argument.type, argument.annotations);
                }
                ((ExceptionLabel)object2).placeStart();
                exceptionLabelArray[n] = object2;
            }
        } else {
            exceptionLabelArray = null;
        }
        if (this.subRoutineStartLabel != null) {
            this.subRoutineStartLabel.initialize(codeStream);
            this.enterAnyExceptionHandler(codeStream);
        }
        try {
            this.declaredExceptionLabels = exceptionLabelArray;
            n = this.resources.length;
            if (n > 0) {
                this.resourceExceptionLabels = new ExceptionLabel[n + 1];
                codeStream.aconst_null();
                codeStream.store(this.primaryExceptionVariable, false);
                codeStream.addVariable(this.primaryExceptionVariable);
                codeStream.aconst_null();
                codeStream.store(this.caughtThrowableVariable, false);
                codeStream.addVariable(this.caughtThrowableVariable);
                for (int i = 0; i <= n; ++i) {
                    this.resourceExceptionLabels[i] = new ExceptionLabel(codeStream, null);
                    this.resourceExceptionLabels[i].placeStart();
                    if (i >= n) continue;
                    object2 = this.resources[i];
                    if (object2 instanceof NameReference) {
                        object = (NameReference)object2;
                        ((NameReference)object).bits |= 0x80000;
                        variableBinding = (VariableBinding)((NameReference)object).binding;
                        ((NameReference)object).checkEffectiveFinality(variableBinding, this.scope);
                    } else if (object2 instanceof FieldReference) {
                        object = (FieldReference)object2;
                        if (!((FieldReference)object).binding.isFinal()) {
                            this.scope.problemReporter().cannotReferToNonFinalField(((FieldReference)object).binding, (ASTNode)object);
                        }
                    }
                    ((Statement)object2).generateCode(this.scope, codeStream);
                }
            }
            this.tryBlock.generateCode(this.scope, codeStream);
            if (n > 0) {
                for (int i = n; i >= 0; --i) {
                    object2 = new BranchLabel(codeStream);
                    this.resourceExceptionLabels[i].placeEnd();
                    Object object3 = object = i > 0 ? this.resources[i - 1] : null;
                    if ((this.bits & 0x20000000) == 0) {
                        if (i > 0) {
                            int n6 = codeStream.position;
                            if (this.postTryInitStateIndex != -1) {
                                codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.postTryInitStateIndex);
                                codeStream.addDefinitelyAssignedVariables(blockScope, this.postTryInitStateIndex);
                            }
                            this.generateCodeSnippet((Statement)object, codeStream, (BranchLabel)object2, false, new int[0]);
                            codeStream.recordPositionsFrom(n6, this.tryBlock.sourceEnd);
                        }
                        codeStream.goto_((BranchLabel)object2);
                    }
                    if (i > 0) {
                        codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.postResourcesInitStateIndexes[i - 1]);
                        codeStream.addDefinitelyAssignedVariables(blockScope, this.postResourcesInitStateIndexes[i - 1]);
                    } else {
                        codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.preTryInitStateIndex);
                        codeStream.addDefinitelyAssignedVariables(blockScope, this.preTryInitStateIndex);
                    }
                    codeStream.pushExceptionOnStack(this.scope.getJavaLangThrowable());
                    this.resourceExceptionLabels[i].place();
                    if (i == n) {
                        codeStream.store(this.primaryExceptionVariable, false);
                    } else {
                        BranchLabel branchLabel = new BranchLabel(codeStream);
                        BranchLabel branchLabel2 = new BranchLabel(codeStream);
                        codeStream.store(this.caughtThrowableVariable, false);
                        codeStream.load(this.primaryExceptionVariable);
                        codeStream.ifnonnull(branchLabel);
                        codeStream.load(this.caughtThrowableVariable);
                        codeStream.store(this.primaryExceptionVariable, false);
                        codeStream.goto_(branchLabel2);
                        branchLabel.place();
                        codeStream.load(this.primaryExceptionVariable);
                        codeStream.load(this.caughtThrowableVariable);
                        codeStream.if_acmpeq(branchLabel2);
                        codeStream.load(this.primaryExceptionVariable);
                        codeStream.load(this.caughtThrowableVariable);
                        codeStream.invokeThrowableAddSuppressed();
                        branchLabel2.place();
                    }
                    if (i > 0) {
                        BranchLabel branchLabel = new BranchLabel(codeStream);
                        this.generateCodeSnippet((Statement)object, codeStream, branchLabel, true, i, codeStream.position);
                        branchLabel.place();
                    }
                    codeStream.load(this.primaryExceptionVariable);
                    codeStream.athrow();
                    ((BranchLabel)object2).place();
                }
                codeStream.removeVariable(this.primaryExceptionVariable);
                codeStream.removeVariable(this.caughtThrowableVariable);
            }
        }
        finally {
            this.declaredExceptionLabels = null;
            this.resourceExceptionLabels = null;
        }
        int n7 = n = codeStream.position != n3 ? 1 : 0;
        if (n != 0) {
            int n8;
            BranchLabel branchLabel = new BranchLabel(codeStream);
            object2 = null;
            for (n8 = 0; n8 < n2; ++n8) {
                exceptionLabelArray[n8].placeEnd();
            }
            if ((this.bits & 0x20000000) == 0) {
                n8 = codeStream.position;
                switch (n4) {
                    case 1: 
                    case 3: {
                        bl2 = true;
                        if (this.naturalExitMergeInitStateIndex != -1) {
                            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.naturalExitMergeInitStateIndex);
                            codeStream.addDefinitelyAssignedVariables(blockScope, this.naturalExitMergeInitStateIndex);
                        }
                        codeStream.goto_(branchLabel);
                        break;
                    }
                    case 0: {
                        if (this.naturalExitMergeInitStateIndex != -1) {
                            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.naturalExitMergeInitStateIndex);
                            codeStream.addDefinitelyAssignedVariables(blockScope, this.naturalExitMergeInitStateIndex);
                        }
                        codeStream.goto_(branchLabel);
                        break;
                    }
                    case 2: {
                        codeStream.goto_(this.subRoutineStartLabel);
                    }
                }
                codeStream.recordPositionsFrom(n8, this.tryBlock.sourceEnd);
            }
            this.exitAnyExceptionHandler();
            if (this.catchArguments != null) {
                object2 = new BranchLabel(codeStream);
                block28: for (n8 = 0; n8 < n2; ++n8) {
                    if (exceptionLabelArray[n8].getCount() == 0) continue;
                    this.enterAnyExceptionHandler(codeStream);
                    if (this.preTryInitStateIndex != -1) {
                        codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.preTryInitStateIndex);
                        codeStream.addDefinitelyAssignedVariables(blockScope, this.preTryInitStateIndex);
                    }
                    codeStream.pushExceptionOnStack(exceptionLabelArray[n8].exceptionType);
                    exceptionLabelArray[n8].place();
                    int n9 = codeStream.position;
                    variableBinding = this.catchArguments[n8].binding;
                    if (((LocalVariableBinding)variableBinding).resolvedPosition != -1) {
                        codeStream.store((LocalVariableBinding)variableBinding, false);
                        ((LocalVariableBinding)variableBinding).recordInitializationStartPC(codeStream.position);
                        codeStream.addVisibleLocalVariable((LocalVariableBinding)variableBinding);
                    } else {
                        codeStream.pop();
                    }
                    codeStream.recordPositionsFrom(n9, this.catchArguments[n8].sourceStart);
                    this.catchBlocks[n8].generateCode(this.scope, codeStream);
                    this.exitAnyExceptionHandler();
                    if (this.catchExits[n8]) continue;
                    switch (n4) {
                        case 3: {
                            if (bl) {
                                ((StackMapFrameCodeStream)codeStream).pushStateIndex(this.naturalExitMergeInitStateIndex);
                            }
                            if (this.catchExitInitStateIndexes[n8] != -1) {
                                codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.catchExitInitStateIndexes[n8]);
                                codeStream.addDefinitelyAssignedVariables(blockScope, this.catchExitInitStateIndexes[n8]);
                            }
                            this.finallyBlock.generateCode(this.scope, codeStream);
                            codeStream.goto_((BranchLabel)object2);
                            if (!bl) continue block28;
                            ((StackMapFrameCodeStream)codeStream).popStateIndex();
                            continue block28;
                        }
                        case 1: {
                            bl2 = true;
                        }
                        case 0: {
                            if (this.naturalExitMergeInitStateIndex != -1) {
                                codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.naturalExitMergeInitStateIndex);
                                codeStream.addDefinitelyAssignedVariables(blockScope, this.naturalExitMergeInitStateIndex);
                            }
                            codeStream.goto_(branchLabel);
                            continue block28;
                        }
                        case 2: {
                            codeStream.goto_(this.subRoutineStartLabel);
                        }
                    }
                }
            }
            ExceptionLabel exceptionLabel = bl2 && n4 == 1 ? new ExceptionLabel(codeStream, null) : null;
            int n10 = codeStream.position;
            if (this.subRoutineStartLabel != null && this.anyExceptionLabel.getCount() != 0) {
                codeStream.pushExceptionOnStack(this.scope.getJavaLangThrowable());
                if (this.preTryInitStateIndex != -1) {
                    codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.preTryInitStateIndex);
                    codeStream.addDefinitelyAssignedVariables(blockScope, this.preTryInitStateIndex);
                }
                this.placeAllAnyExceptionHandler();
                if (exceptionLabel != null) {
                    exceptionLabel.place();
                }
                switch (n4) {
                    case 1: {
                        codeStream.store(this.anyExceptionVariable, false);
                        codeStream.jsr(this.subRoutineStartLabel);
                        codeStream.recordPositionsFrom(n10, this.finallyBlock.sourceStart);
                        int n11 = codeStream.position;
                        codeStream.throwAnyException(this.anyExceptionVariable);
                        codeStream.recordPositionsFrom(n11, this.finallyBlock.sourceEnd);
                        this.subRoutineStartLabel.place();
                        codeStream.pushExceptionOnStack(this.scope.getJavaLangThrowable());
                        n11 = codeStream.position;
                        codeStream.store(this.returnAddressVariable, false);
                        codeStream.recordPositionsFrom(n11, this.finallyBlock.sourceStart);
                        this.finallyBlock.generateCode(this.scope, codeStream);
                        n11 = codeStream.position;
                        codeStream.ret(this.returnAddressVariable.resolvedPosition);
                        codeStream.recordPositionsFrom(n11, this.finallyBlock.sourceEnd);
                        break;
                    }
                    case 3: {
                        codeStream.store(this.anyExceptionVariable, false);
                        codeStream.addVariable(this.anyExceptionVariable);
                        codeStream.recordPositionsFrom(n10, this.finallyBlock.sourceStart);
                        this.finallyBlock.generateCode(blockScope, codeStream);
                        int n12 = codeStream.position;
                        codeStream.throwAnyException(this.anyExceptionVariable);
                        codeStream.removeVariable(this.anyExceptionVariable);
                        if (this.preTryInitStateIndex != -1) {
                            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.preTryInitStateIndex);
                        }
                        this.subRoutineStartLabel.place();
                        codeStream.recordPositionsFrom(n12, this.finallyBlock.sourceEnd);
                        break;
                    }
                    case 2: {
                        codeStream.pop();
                        this.subRoutineStartLabel.place();
                        codeStream.recordPositionsFrom(n10, this.finallyBlock.sourceStart);
                        this.finallyBlock.generateCode(this.scope, codeStream);
                    }
                }
                if (bl2) {
                    switch (n4) {
                        case 1: {
                            branchLabel.place();
                            int n13 = codeStream.position;
                            exceptionLabel.placeStart();
                            codeStream.jsr(this.subRoutineStartLabel);
                            exceptionLabel.placeEnd();
                            codeStream.recordPositionsFrom(n13, this.finallyBlock.sourceEnd);
                            break;
                        }
                        case 3: {
                            if (bl) {
                                ((StackMapFrameCodeStream)codeStream).pushStateIndex(this.naturalExitMergeInitStateIndex);
                            }
                            if (this.naturalExitMergeInitStateIndex != -1) {
                                codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.naturalExitMergeInitStateIndex);
                                codeStream.addDefinitelyAssignedVariables(blockScope, this.naturalExitMergeInitStateIndex);
                            }
                            branchLabel.place();
                            this.finallyBlock.generateCode(this.scope, codeStream);
                            if (object2 != null) {
                                int n14 = codeStream.position;
                                codeStream.goto_((BranchLabel)object2);
                                codeStream.recordPositionsFrom(n14, this.finallyBlock.sourceEnd);
                            }
                            if (!bl) break;
                            ((StackMapFrameCodeStream)codeStream).popStateIndex();
                            break;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            branchLabel.place();
                        }
                    }
                }
                if (object2 != null) {
                    ((BranchLabel)object2).place();
                }
            } else {
                branchLabel.place();
            }
        } else if (this.subRoutineStartLabel != null) {
            this.finallyBlock.generateCode(this.scope, codeStream);
        }
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
            codeStream.addDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
        }
        codeStream.recordPositionsFrom(n3, this.sourceStart);
    }

    private void generateCodeSnippet(Statement statement, CodeStream codeStream, BranchLabel branchLabel, boolean bl, int ... nArray) {
        int n = -1;
        int n2 = -1;
        if (bl) {
            n = nArray[0];
            n2 = nArray[1];
        }
        if (statement instanceof LocalDeclaration) {
            this.generateCodeSnippet((LocalDeclaration)statement, codeStream, branchLabel, bl, n, n2);
        } else if (statement instanceof Reference) {
            this.generateCodeSnippet((Reference)statement, codeStream, branchLabel, bl, n, n2);
        }
    }

    private void generateCodeSnippet(Reference reference, CodeStream codeStream, BranchLabel branchLabel, boolean bl, int n, int n2) {
        reference.generateCode(this.scope, codeStream, true);
        codeStream.ifnull(branchLabel);
        reference.generateCode(this.scope, codeStream, true);
        codeStream.invokeAutoCloseableClose(reference.resolvedType);
        if (!bl) {
            return;
        }
        codeStream.recordPositionsFrom(n2, this.tryBlock.sourceEnd);
        this.isDuplicateResourceReference(n);
    }

    private void generateCodeSnippet(LocalDeclaration localDeclaration, CodeStream codeStream, BranchLabel branchLabel, boolean bl, int n, int n2) {
        LocalVariableBinding localVariableBinding = localDeclaration.binding;
        codeStream.load(localVariableBinding);
        codeStream.ifnull(branchLabel);
        codeStream.load(localVariableBinding);
        codeStream.invokeAutoCloseableClose(localVariableBinding.type);
        if (!bl) {
            return;
        }
        codeStream.recordPositionsFrom(n2, this.tryBlock.sourceEnd);
        if (!this.isDuplicateResourceReference(n)) {
            codeStream.removeVariable(localVariableBinding);
        }
    }

    private boolean isDuplicateResourceReference(int n) {
        int n2 = this.resources.length;
        if (n < n2 && this.resources[n] instanceof Reference) {
            Binding binding;
            Reference reference = (Reference)this.resources[n];
            Binding binding2 = reference instanceof NameReference ? ((NameReference)reference).binding : (binding = reference instanceof FieldReference ? ((FieldReference)reference).binding : null);
            if (binding == null) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                LocalVariableBinding localVariableBinding;
                Statement statement = this.resources[i];
                Binding binding3 = statement instanceof LocalDeclaration ? ((LocalDeclaration)statement).binding : (statement instanceof NameReference ? ((NameReference)statement).binding : (localVariableBinding = statement instanceof FieldReference ? ((FieldReference)statement).binding : null));
                if (localVariableBinding != binding) continue;
                this.scope.problemReporter().duplicateResourceReference(reference);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean generateSubRoutineInvocation(BlockScope blockScope, CodeStream codeStream, Object object, int n, LocalVariableBinding localVariableBinding) {
        int n2;
        int n3 = this.resources.length;
        if (n3 > 0 && this.resourceExceptionLabels != null) {
            for (n2 = n3; n2 > 0; --n2) {
                this.resourceExceptionLabels[n2].placeEnd();
                BranchLabel branchLabel = new BranchLabel(codeStream);
                int n4 = codeStream.position;
                this.generateCodeSnippet(this.resources[n2 - 1], codeStream, branchLabel, false, new int[0]);
                codeStream.recordPositionsFrom(n4, this.tryBlock.sourceEnd);
                branchLabel.place();
            }
            this.resourceExceptionLabels[0].placeEnd();
        }
        n2 = codeStream instanceof StackMapFrameCodeStream;
        int n5 = this.finallyMode();
        switch (n5) {
            case 2: {
                if (this.switchExpression != null) {
                    this.finallyBlock.generateCode(blockScope, codeStream);
                    return true;
                }
                codeStream.goto_(this.subRoutineStartLabel);
                return true;
            }
            case 0: {
                if (this.switchExpression == null) {
                    this.exitDeclaredExceptionHandlers(codeStream);
                }
                return false;
            }
        }
        CompilerOptions compilerOptions = this.scope.compilerOptions();
        if (compilerOptions.shareCommonFinallyBlocks && object != null) {
            boolean bl = true;
            if (this.reusableJSRTargetsCount > 0) {
                int n6 = this.reusableJSRTargetsCount;
                for (int i = 0; i < n6; ++i) {
                    Object object2 = this.reusableJSRTargets[i];
                    if (object != object2 && (!(object instanceof Constant) || !(object2 instanceof Constant) || !((Constant)object).hasSameValue((Constant)object2))) continue;
                    if (this.reusableJSRStateIndexes[i] != n && n5 == 3) {
                        bl = false;
                        break;
                    }
                    codeStream.goto_(this.reusableJSRSequenceStartLabels[i]);
                    return true;
                }
            } else {
                this.reusableJSRTargets = new Object[3];
                this.reusableJSRSequenceStartLabels = new BranchLabel[3];
                this.reusableJSRStateIndexes = new int[3];
            }
            if (bl) {
                if (this.reusableJSRTargetsCount == this.reusableJSRTargets.length) {
                    this.reusableJSRTargets = new Object[2 * this.reusableJSRTargetsCount];
                    System.arraycopy(this.reusableJSRTargets, 0, this.reusableJSRTargets, 0, this.reusableJSRTargetsCount);
                    this.reusableJSRSequenceStartLabels = new BranchLabel[2 * this.reusableJSRTargetsCount];
                    System.arraycopy(this.reusableJSRSequenceStartLabels, 0, this.reusableJSRSequenceStartLabels, 0, this.reusableJSRTargetsCount);
                    this.reusableJSRStateIndexes = new int[2 * this.reusableJSRTargetsCount];
                    System.arraycopy(this.reusableJSRStateIndexes, 0, this.reusableJSRStateIndexes, 0, this.reusableJSRTargetsCount);
                }
                this.reusableJSRTargets[this.reusableJSRTargetsCount] = object;
                BranchLabel branchLabel = new BranchLabel(codeStream);
                branchLabel.place();
                this.reusableJSRStateIndexes[this.reusableJSRTargetsCount] = n;
                this.reusableJSRSequenceStartLabels[this.reusableJSRTargetsCount++] = branchLabel;
            }
        }
        if (n5 == 3) {
            if (n2 != 0) {
                ((StackMapFrameCodeStream)codeStream).pushStateIndex(n);
            }
            this.exitAnyExceptionHandler();
            this.exitDeclaredExceptionHandlers(codeStream);
            this.finallyBlock.generateCode(blockScope, codeStream);
            if (n2 != 0) {
                ((StackMapFrameCodeStream)codeStream).popStateIndex();
            }
        } else {
            codeStream.jsr(this.subRoutineStartLabel);
            this.exitAnyExceptionHandler();
            this.exitDeclaredExceptionHandlers(codeStream);
        }
        return false;
    }

    @Override
    public boolean isSubRoutineEscaping() {
        return (this.bits & 0x4000) != 0;
    }

    @Override
    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        int n2;
        int n3 = this.resources.length;
        TryStatement.printIndent(n, stringBuffer).append("try" + (n3 == 0 ? "\n" : " ("));
        for (n2 = 0; n2 < n3; ++n2) {
            Statement statement = this.resources[n2];
            if (statement instanceof LocalDeclaration) {
                ((LocalDeclaration)statement).printAsExpression(0, stringBuffer);
            } else {
                if (!(statement instanceof Reference)) continue;
                ((Reference)statement).printExpression(0, stringBuffer);
            }
            if (n2 == n3 - 1) continue;
            stringBuffer.append(";\n");
            TryStatement.printIndent(n + 2, stringBuffer);
        }
        if (n3 > 0) {
            stringBuffer.append(")\n");
        }
        this.tryBlock.printStatement(n + 1, stringBuffer);
        if (this.catchBlocks != null) {
            for (n2 = 0; n2 < this.catchBlocks.length; ++n2) {
                stringBuffer.append('\n');
                TryStatement.printIndent(n, stringBuffer).append("catch (");
                this.catchArguments[n2].print(0, stringBuffer).append(")\n");
                this.catchBlocks[n2].printStatement(n + 1, stringBuffer);
            }
        }
        if (this.finallyBlock != null) {
            stringBuffer.append('\n');
            TryStatement.printIndent(n, stringBuffer).append("finally\n");
            this.finallyBlock.printStatement(n + 1, stringBuffer);
        }
        return stringBuffer;
    }

    @Override
    public void resolve(BlockScope blockScope) {
        TypeBinding typeBinding;
        Binding binding;
        Object object;
        this.scope = new BlockScope(blockScope);
        BlockScope blockScope2 = null;
        BlockScope blockScope3 = null;
        int n = this.resources.length;
        if (n > 0) {
            blockScope3 = new BlockScope(this.scope);
            this.primaryExceptionVariable = new LocalVariableBinding(SECRET_PRIMARY_EXCEPTION_VARIABLE_NAME, (TypeBinding)this.scope.getJavaLangThrowable(), 0, false);
            blockScope3.addLocalVariable(this.primaryExceptionVariable);
            this.primaryExceptionVariable.setConstant(Constant.NotAConstant);
            this.caughtThrowableVariable = new LocalVariableBinding(SECRET_CAUGHT_THROWABLE_VARIABLE_NAME, (TypeBinding)this.scope.getJavaLangThrowable(), 0, false);
            blockScope3.addLocalVariable(this.caughtThrowableVariable);
            this.caughtThrowableVariable.setConstant(Constant.NotAConstant);
        }
        for (int i = 0; i < n; ++i) {
            this.resources[i].resolve(blockScope3);
            if (this.resources[i] instanceof LocalDeclaration) {
                object = (LocalDeclaration)this.resources[i];
                binding = ((LocalDeclaration)object).binding;
                if (binding == null || !binding.isValidBinding()) continue;
                ((LocalVariableBinding)binding).modifiers |= 0x10;
                ((LocalVariableBinding)binding).tagBits |= 0x2000L;
                typeBinding = ((LocalVariableBinding)binding).type;
                if (typeBinding instanceof ReferenceBinding) {
                    if (typeBinding.findSuperTypeOriginatingFrom(62, false) != null || !typeBinding.isValidBinding()) continue;
                    blockScope.problemReporter().resourceHasToImplementAutoCloseable(typeBinding, ((LocalDeclaration)object).type);
                    ((LocalVariableBinding)binding).type = new ProblemReferenceBinding(CharOperation.splitOn('.', typeBinding.shortReadableName()), null, 15);
                    continue;
                }
                if (typeBinding == null) continue;
                blockScope.problemReporter().resourceHasToImplementAutoCloseable(typeBinding, ((LocalDeclaration)object).type);
                ((LocalVariableBinding)binding).type = new ProblemReferenceBinding(CharOperation.splitOn('.', typeBinding.shortReadableName()), null, 15);
                continue;
            }
            object = (Expression)this.resources[i];
            binding = ((Expression)object).resolvedType;
            if (binding instanceof ReferenceBinding) {
                if (((TypeBinding)binding).findSuperTypeOriginatingFrom(62, false) != null || !binding.isValidBinding()) continue;
                blockScope.problemReporter().resourceHasToImplementAutoCloseable((TypeBinding)binding, (ASTNode)object);
                ((Expression)this.resources[i]).resolvedType = new ProblemReferenceBinding(CharOperation.splitOn('.', binding.shortReadableName()), null, 15);
                continue;
            }
            if (binding == null) continue;
            blockScope.problemReporter().resourceHasToImplementAutoCloseable((TypeBinding)binding, (ASTNode)object);
            ((Expression)this.resources[i]).resolvedType = new ProblemReferenceBinding(CharOperation.splitOn('.', binding.shortReadableName()), null, 15);
        }
        BlockScope blockScope4 = new BlockScope(blockScope3 != null ? blockScope3 : this.scope);
        if (this.finallyBlock != null) {
            if (this.finallyBlock.isEmptyBlock()) {
                if ((this.finallyBlock.bits & 8) != 0) {
                    this.scope.problemReporter().undocumentedEmptyBlock(this.finallyBlock.sourceStart, this.finallyBlock.sourceEnd);
                }
            } else {
                blockScope2 = new BlockScope(this.scope, false);
                object = this.scope.methodScope();
                if (!blockScope.compilerOptions().inlineJsrBytecode) {
                    this.returnAddressVariable = new LocalVariableBinding(SECRET_RETURN_ADDRESS_NAME, (TypeBinding)blockScope.getJavaLangObject(), 0, false);
                    blockScope2.addLocalVariable(this.returnAddressVariable);
                    this.returnAddressVariable.setConstant(Constant.NotAConstant);
                }
                this.subRoutineStartLabel = new BranchLabel();
                this.anyExceptionVariable = new LocalVariableBinding(SECRET_ANY_HANDLER_NAME, (TypeBinding)this.scope.getJavaLangThrowable(), 0, false);
                blockScope2.addLocalVariable(this.anyExceptionVariable);
                this.anyExceptionVariable.setConstant(Constant.NotAConstant);
                if (!((MethodScope)object).isInsideInitializer()) {
                    Binding binding2 = ((MethodScope)object).referenceContext instanceof AbstractMethodDeclaration ? ((AbstractMethodDeclaration)((MethodScope)object).referenceContext).binding : (binding = ((MethodScope)object).referenceContext instanceof LambdaExpression ? ((LambdaExpression)((MethodScope)object).referenceContext).binding : null);
                    if (binding != null) {
                        typeBinding = ((MethodBinding)binding).returnType;
                        if (typeBinding.id != 6) {
                            this.secretReturnValue = new LocalVariableBinding(SECRET_RETURN_VALUE_NAME, typeBinding, 0, false);
                            blockScope2.addLocalVariable(this.secretReturnValue);
                            this.secretReturnValue.setConstant(Constant.NotAConstant);
                        }
                    }
                }
                this.finallyBlock.resolveUsing(blockScope2);
                int n2 = this.catchArguments == null ? 1 : this.catchArguments.length + 1;
                blockScope2.shiftScopes = new BlockScope[n2];
                blockScope2.shiftScopes[0] = blockScope4;
            }
        }
        this.tryBlock.resolveUsing(blockScope4);
        if (this.catchBlocks != null) {
            int n3 = this.catchArguments.length;
            TypeBinding[] typeBindingArray = new TypeBinding[n3];
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < n3; ++i) {
                BlockScope blockScope5 = new BlockScope(this.scope);
                if (blockScope2 != null) {
                    blockScope2.shiftScopes[i + 1] = blockScope5;
                }
                Argument argument = this.catchArguments[i];
                bl |= (argument.type.bits & 0x20000000) != 0;
                typeBindingArray[i] = argument.resolveForCatch(blockScope5);
                if (typeBindingArray[i] == null) {
                    bl2 = true;
                }
                this.catchBlocks[i].resolveUsing(blockScope5);
            }
            if (bl2) {
                return;
            }
            this.verifyDuplicationAndOrder(n3, typeBindingArray, bl);
        } else {
            this.caughtExceptionTypes = new ReferenceBinding[0];
        }
        if (blockScope2 != null) {
            this.scope.addSubscope(blockScope2);
        }
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n;
            Statement[] statementArray = this.resources;
            int n2 = statementArray.length;
            for (n = 0; n < n2; ++n) {
                statementArray[n].traverse(aSTVisitor, this.scope);
            }
            this.tryBlock.traverse(aSTVisitor, this.scope);
            if (this.catchArguments != null) {
                n2 = this.catchBlocks.length;
                for (n = 0; n < n2; ++n) {
                    this.catchArguments[n].traverse(aSTVisitor, this.scope);
                    this.catchBlocks[n].traverse(aSTVisitor, this.scope);
                }
            }
            if (this.finallyBlock != null) {
                this.finallyBlock.traverse(aSTVisitor, this.scope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    protected void verifyDuplicationAndOrder(int n, TypeBinding[] typeBindingArray, boolean bl) {
        if (bl) {
            int n2;
            Object object;
            int n3;
            ReferenceBinding[] referenceBindingArray;
            int n4;
            int n5 = 0;
            ReferenceBinding[][] referenceBindingArrayArray = new ReferenceBinding[n][];
            for (n4 = 0; n4 < n; ++n4) {
                if (typeBindingArray[n4] instanceof ArrayBinding) continue;
                ReferenceBinding referenceBinding = (ReferenceBinding)typeBindingArray[n4];
                referenceBindingArray = this.catchArguments[n4].type;
                if ((referenceBindingArray.bits & 0x20000000) != 0) {
                    TypeReference[] typeReferenceArray = ((UnionTypeReference)referenceBindingArray).typeReferences;
                    n3 = typeReferenceArray.length;
                    object = new ReferenceBinding[n3];
                    for (n2 = 0; n2 < n3; ++n2) {
                        object[n2] = (ReferenceBinding)typeReferenceArray[n2].resolvedType;
                    }
                    n5 += n3;
                    referenceBindingArrayArray[n4] = object;
                    continue;
                }
                referenceBindingArrayArray[n4] = new ReferenceBinding[]{referenceBinding};
                ++n5;
            }
            this.caughtExceptionTypes = new ReferenceBinding[n5];
            this.caughtExceptionsCatchBlocks = new int[n5];
            int n6 = 0;
            block2: for (n4 = 0; n4 < n; ++n4) {
                referenceBindingArray = referenceBindingArrayArray[n4];
                if (referenceBindingArray == null) continue;
                n3 = referenceBindingArray.length;
                for (int i = 0; i < n3; ++i) {
                    this.caughtExceptionTypes[n6] = object = referenceBindingArray[i];
                    this.caughtExceptionsCatchBlocks[n6++] = n4;
                    for (n2 = 0; n2 < n4; ++n2) {
                        ReferenceBinding[] referenceBindingArray2 = referenceBindingArrayArray[n2];
                        if (referenceBindingArray2 == null) continue;
                        for (ReferenceBinding referenceBinding : referenceBindingArray2) {
                            if (!((TypeBinding)object).isCompatibleWith(referenceBinding)) continue;
                            TypeReference typeReference = this.catchArguments[n4].type;
                            if ((typeReference.bits & 0x20000000) != 0) {
                                typeReference = ((UnionTypeReference)typeReference).typeReferences[i];
                            }
                            this.scope.problemReporter().wrongSequenceOfExceptionTypesError(typeReference, (TypeBinding)object, referenceBinding);
                            continue block2;
                        }
                    }
                }
            }
        } else {
            this.caughtExceptionTypes = new ReferenceBinding[n];
            for (int i = 0; i < n; ++i) {
                if (typeBindingArray[i] instanceof ArrayBinding) continue;
                this.caughtExceptionTypes[i] = (ReferenceBinding)typeBindingArray[i];
                for (int j = 0; j < i; ++j) {
                    if (!this.caughtExceptionTypes[i].isCompatibleWith(typeBindingArray[j])) continue;
                    this.scope.problemReporter().wrongSequenceOfExceptionTypesError(this.catchArguments[i].type, this.caughtExceptionTypes[i], typeBindingArray[j]);
                }
            }
        }
    }

    @Override
    public boolean doesNotCompleteNormally() {
        if (!this.tryBlock.doesNotCompleteNormally()) {
            return this.finallyBlock != null ? this.finallyBlock.doesNotCompleteNormally() : false;
        }
        if (this.catchBlocks != null) {
            for (int i = 0; i < this.catchBlocks.length; ++i) {
                if (this.catchBlocks[i].doesNotCompleteNormally()) continue;
                return this.finallyBlock != null ? this.finallyBlock.doesNotCompleteNormally() : false;
            }
        }
        return true;
    }

    @Override
    public boolean completesByContinue() {
        if (this.tryBlock.completesByContinue()) {
            return this.finallyBlock == null ? true : !this.finallyBlock.doesNotCompleteNormally() || this.finallyBlock.completesByContinue();
        }
        if (this.catchBlocks != null) {
            for (int i = 0; i < this.catchBlocks.length; ++i) {
                if (!this.catchBlocks[i].completesByContinue()) continue;
                return this.finallyBlock == null ? true : !this.finallyBlock.doesNotCompleteNormally() || this.finallyBlock.completesByContinue();
            }
        }
        return this.finallyBlock != null && this.finallyBlock.completesByContinue();
    }

    @Override
    public boolean canCompleteNormally() {
        if (this.tryBlock.canCompleteNormally()) {
            return this.finallyBlock != null ? this.finallyBlock.canCompleteNormally() : true;
        }
        if (this.catchBlocks != null) {
            for (int i = 0; i < this.catchBlocks.length; ++i) {
                if (!this.catchBlocks[i].canCompleteNormally()) continue;
                return this.finallyBlock != null ? this.finallyBlock.canCompleteNormally() : true;
            }
        }
        return false;
    }

    @Override
    public boolean continueCompletes() {
        if (this.tryBlock.continueCompletes()) {
            return this.finallyBlock == null ? true : this.finallyBlock.canCompleteNormally() || this.finallyBlock.continueCompletes();
        }
        if (this.catchBlocks != null) {
            for (int i = 0; i < this.catchBlocks.length; ++i) {
                if (!this.catchBlocks[i].continueCompletes()) continue;
                return this.finallyBlock == null ? true : this.finallyBlock.canCompleteNormally() || this.finallyBlock.continueCompletes();
            }
        }
        return this.finallyBlock != null && this.finallyBlock.continueCompletes();
    }
}

