# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_asciinema_global_optspecs
	string join \n q/quiet h/help V/version
end

function __fish_asciinema_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_asciinema_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_asciinema_using_subcommand
	set -l cmd (__fish_asciinema_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c asciinema -n "__fish_asciinema_needs_command" -s q -l quiet -d 'Quiet mode - suppress diagnostic messages'
complete -c asciinema -n "__fish_asciinema_needs_command" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c asciinema -n "__fish_asciinema_needs_command" -s V -l version -d 'Print version'
complete -c asciinema -n "__fish_asciinema_needs_command" -f -a "record" -d 'Record a terminal session'
complete -c asciinema -n "__fish_asciinema_needs_command" -f -a "rec" -d 'Record a terminal session'
complete -c asciinema -n "__fish_asciinema_needs_command" -f -a "stream" -d 'Stream a terminal session'
complete -c asciinema -n "__fish_asciinema_needs_command" -f -a "session" -d 'Record and stream a terminal session'
complete -c asciinema -n "__fish_asciinema_needs_command" -f -a "play" -d 'Play back a terminal session'
complete -c asciinema -n "__fish_asciinema_needs_command" -f -a "upload" -d 'Upload a recording to an asciinema server'
complete -c asciinema -n "__fish_asciinema_needs_command" -f -a "auth" -d 'Authenticate this CLI with an asciinema server account'
complete -c asciinema -n "__fish_asciinema_needs_command" -f -a "cat" -d 'Concatenate multiple recordings'
complete -c asciinema -n "__fish_asciinema_needs_command" -f -a "convert" -d 'Convert a recording to another format'
complete -c asciinema -n "__fish_asciinema_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c asciinema -n "__fish_asciinema_using_subcommand record" -s f -l output-format -d 'Output file format [default: asciicast-v3]' -r -f -a "asciicast-v3\t'Full-featured session format, with timing and metadata (current generation) - https://docs.asciinema.org/manual/asciicast/v3/'
asciicast-v2\t'Full-featured session format, with timing and metadata (previous generation) - https://docs.asciinema.org/manual/asciicast/v2/'
raw\t'Raw terminal output, including control sequences, without timing and metadata'
txt\t'Plain text without colors or control sequences, human-readable'"
complete -c asciinema -n "__fish_asciinema_using_subcommand record" -s c -l command -d 'Command to start in the session [default: $SHELL]' -r
complete -c asciinema -n "__fish_asciinema_using_subcommand record" -l rec-env -d 'Comma-separated list of environment variables to capture [default: SHELL]' -r
complete -c asciinema -n "__fish_asciinema_using_subcommand record" -s t -l title -d 'Title of the recording' -r
complete -c asciinema -n "__fish_asciinema_using_subcommand record" -s i -l idle-time-limit -d 'Limit idle time to a given number of seconds' -r
complete -c asciinema -n "__fish_asciinema_using_subcommand record" -l window-size -d 'Override session\'s terminal window size' -r
complete -c asciinema -n "__fish_asciinema_using_subcommand record" -l log-file -d 'Log file path' -r -F
complete -c asciinema -n "__fish_asciinema_using_subcommand record" -l cols -r
complete -c asciinema -n "__fish_asciinema_using_subcommand record" -l rows -r
complete -c asciinema -n "__fish_asciinema_using_subcommand record" -s I -l rec-input -d 'Enable input (keyboard) recording'
complete -c asciinema -n "__fish_asciinema_using_subcommand record" -s a -l append -d 'Append to an existing recording file'
complete -c asciinema -n "__fish_asciinema_using_subcommand record" -l overwrite -d 'Overwrite the output file if it already exists'
complete -c asciinema -n "__fish_asciinema_using_subcommand record" -l headless -d 'Headless mode - don\'t use the terminal for I/O'
complete -c asciinema -n "__fish_asciinema_using_subcommand record" -l return -d 'Return the session\'s exit status'
complete -c asciinema -n "__fish_asciinema_using_subcommand record" -l raw
complete -c asciinema -n "__fish_asciinema_using_subcommand record" -s q -l quiet -d 'Quiet mode - suppress diagnostic messages'
complete -c asciinema -n "__fish_asciinema_using_subcommand record" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c asciinema -n "__fish_asciinema_using_subcommand rec" -s f -l output-format -d 'Output file format [default: asciicast-v3]' -r -f -a "asciicast-v3\t'Full-featured session format, with timing and metadata (current generation) - https://docs.asciinema.org/manual/asciicast/v3/'
asciicast-v2\t'Full-featured session format, with timing and metadata (previous generation) - https://docs.asciinema.org/manual/asciicast/v2/'
raw\t'Raw terminal output, including control sequences, without timing and metadata'
txt\t'Plain text without colors or control sequences, human-readable'"
complete -c asciinema -n "__fish_asciinema_using_subcommand rec" -s c -l command -d 'Command to start in the session [default: $SHELL]' -r
complete -c asciinema -n "__fish_asciinema_using_subcommand rec" -l rec-env -d 'Comma-separated list of environment variables to capture [default: SHELL]' -r
complete -c asciinema -n "__fish_asciinema_using_subcommand rec" -s t -l title -d 'Title of the recording' -r
complete -c asciinema -n "__fish_asciinema_using_subcommand rec" -s i -l idle-time-limit -d 'Limit idle time to a given number of seconds' -r
complete -c asciinema -n "__fish_asciinema_using_subcommand rec" -l window-size -d 'Override session\'s terminal window size' -r
complete -c asciinema -n "__fish_asciinema_using_subcommand rec" -l log-file -d 'Log file path' -r -F
complete -c asciinema -n "__fish_asciinema_using_subcommand rec" -l cols -r
complete -c asciinema -n "__fish_asciinema_using_subcommand rec" -l rows -r
complete -c asciinema -n "__fish_asciinema_using_subcommand rec" -s I -l rec-input -d 'Enable input (keyboard) recording'
complete -c asciinema -n "__fish_asciinema_using_subcommand rec" -s a -l append -d 'Append to an existing recording file'
complete -c asciinema -n "__fish_asciinema_using_subcommand rec" -l overwrite -d 'Overwrite the output file if it already exists'
complete -c asciinema -n "__fish_asciinema_using_subcommand rec" -l headless -d 'Headless mode - don\'t use the terminal for I/O'
complete -c asciinema -n "__fish_asciinema_using_subcommand rec" -l return -d 'Return the session\'s exit status'
complete -c asciinema -n "__fish_asciinema_using_subcommand rec" -l raw
complete -c asciinema -n "__fish_asciinema_using_subcommand rec" -s q -l quiet -d 'Quiet mode - suppress diagnostic messages'
complete -c asciinema -n "__fish_asciinema_using_subcommand rec" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c asciinema -n "__fish_asciinema_using_subcommand stream" -s l -l local -d 'Stream via local HTTP server' -r
complete -c asciinema -n "__fish_asciinema_using_subcommand stream" -s r -l remote -d 'Stream via remote asciinema server' -r
complete -c asciinema -n "__fish_asciinema_using_subcommand stream" -s c -l command -d 'Command to start in the session [default: $SHELL]' -r
complete -c asciinema -n "__fish_asciinema_using_subcommand stream" -l rec-env -d 'Comma-separated list of environment variables to capture [default: SHELL]' -r
complete -c asciinema -n "__fish_asciinema_using_subcommand stream" -s t -l title -d 'Title of the session' -r
complete -c asciinema -n "__fish_asciinema_using_subcommand stream" -l window-size -d 'Override session\'s terminal window size' -r
complete -c asciinema -n "__fish_asciinema_using_subcommand stream" -l log-file -d 'Log file path' -r -F
complete -c asciinema -n "__fish_asciinema_using_subcommand stream" -l server-url -d 'asciinema server URL' -r
complete -c asciinema -n "__fish_asciinema_using_subcommand stream" -s I -l rec-input -d 'Enable input (keyboard) recording'
complete -c asciinema -n "__fish_asciinema_using_subcommand stream" -l headless -d 'Headless mode - don\'t use the terminal for I/O'
complete -c asciinema -n "__fish_asciinema_using_subcommand stream" -l return -d 'Return the session\'s exit status'
complete -c asciinema -n "__fish_asciinema_using_subcommand stream" -s q -l quiet -d 'Quiet mode - suppress diagnostic messages'
complete -c asciinema -n "__fish_asciinema_using_subcommand stream" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c asciinema -n "__fish_asciinema_using_subcommand session" -s o -l output-file -d 'Save the session to a file' -r
complete -c asciinema -n "__fish_asciinema_using_subcommand session" -s f -l output-format -d 'Output file format [default: asciicast-v3]' -r -f -a "asciicast-v3\t'Full-featured session format, with timing and metadata (current generation) - https://docs.asciinema.org/manual/asciicast/v3/'
asciicast-v2\t'Full-featured session format, with timing and metadata (previous generation) - https://docs.asciinema.org/manual/asciicast/v2/'
raw\t'Raw terminal output, including control sequences, without timing and metadata'
txt\t'Plain text without colors or control sequences, human-readable'"
complete -c asciinema -n "__fish_asciinema_using_subcommand session" -s l -l stream-local -d 'Stream via local HTTP server' -r
complete -c asciinema -n "__fish_asciinema_using_subcommand session" -s r -l stream-remote -d 'Stream via remote asciinema server' -r
complete -c asciinema -n "__fish_asciinema_using_subcommand session" -s c -l command -d 'Command to start in the session [default: $SHELL]' -r
complete -c asciinema -n "__fish_asciinema_using_subcommand session" -l rec-env -d 'Comma-separated list of environment variables to capture [default: SHELL]' -r
complete -c asciinema -n "__fish_asciinema_using_subcommand session" -s t -l title -d 'Title of the session' -r
complete -c asciinema -n "__fish_asciinema_using_subcommand session" -s i -l idle-time-limit -d 'Limit idle time to a given number of seconds' -r
complete -c asciinema -n "__fish_asciinema_using_subcommand session" -l window-size -d 'Override session\'s terminal window size' -r
complete -c asciinema -n "__fish_asciinema_using_subcommand session" -l log-file -d 'Log file path' -r -F
complete -c asciinema -n "__fish_asciinema_using_subcommand session" -l server-url -d 'asciinema server URL' -r
complete -c asciinema -n "__fish_asciinema_using_subcommand session" -s I -l rec-input -d 'Enable input (keyboard) recording'
complete -c asciinema -n "__fish_asciinema_using_subcommand session" -s a -l append -d 'Append to an existing recording file'
complete -c asciinema -n "__fish_asciinema_using_subcommand session" -l overwrite -d 'Overwrite the output file if it already exists'
complete -c asciinema -n "__fish_asciinema_using_subcommand session" -l headless -d 'Headless mode - don\'t use the terminal for I/O'
complete -c asciinema -n "__fish_asciinema_using_subcommand session" -l return -d 'Return the session\'s exit status'
complete -c asciinema -n "__fish_asciinema_using_subcommand session" -s q -l quiet -d 'Quiet mode - suppress diagnostic messages'
complete -c asciinema -n "__fish_asciinema_using_subcommand session" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c asciinema -n "__fish_asciinema_using_subcommand play" -s s -l speed -d 'Set playback speed' -r
complete -c asciinema -n "__fish_asciinema_using_subcommand play" -s i -l idle-time-limit -d 'Limit idle time to a given number of seconds' -r
complete -c asciinema -n "__fish_asciinema_using_subcommand play" -s l -l loop -d 'Loop playback continuously'
complete -c asciinema -n "__fish_asciinema_using_subcommand play" -s m -l pause-on-markers -d 'Automatically pause on markers'
complete -c asciinema -n "__fish_asciinema_using_subcommand play" -s r -l resize -d 'Auto-resize terminal to match original size'
complete -c asciinema -n "__fish_asciinema_using_subcommand play" -s q -l quiet -d 'Quiet mode - suppress diagnostic messages'
complete -c asciinema -n "__fish_asciinema_using_subcommand play" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c asciinema -n "__fish_asciinema_using_subcommand upload" -l server-url -d 'asciinema server URL' -r
complete -c asciinema -n "__fish_asciinema_using_subcommand upload" -s q -l quiet -d 'Quiet mode - suppress diagnostic messages'
complete -c asciinema -n "__fish_asciinema_using_subcommand upload" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c asciinema -n "__fish_asciinema_using_subcommand auth" -l server-url -d 'asciinema server URL' -r
complete -c asciinema -n "__fish_asciinema_using_subcommand auth" -s q -l quiet -d 'Quiet mode - suppress diagnostic messages'
complete -c asciinema -n "__fish_asciinema_using_subcommand auth" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c asciinema -n "__fish_asciinema_using_subcommand cat" -s q -l quiet -d 'Quiet mode - suppress diagnostic messages'
complete -c asciinema -n "__fish_asciinema_using_subcommand cat" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c asciinema -n "__fish_asciinema_using_subcommand convert" -s f -l output-format -d 'Output file format [default: asciicast-v3]' -r -f -a "asciicast-v3\t'Full-featured session format, with timing and metadata (current generation) - https://docs.asciinema.org/manual/asciicast/v3/'
asciicast-v2\t'Full-featured session format, with timing and metadata (previous generation) - https://docs.asciinema.org/manual/asciicast/v2/'
raw\t'Raw terminal output, including control sequences, without timing and metadata'
txt\t'Plain text without colors or control sequences, human-readable'"
complete -c asciinema -n "__fish_asciinema_using_subcommand convert" -l overwrite -d 'Overwrite the output file if it already exists'
complete -c asciinema -n "__fish_asciinema_using_subcommand convert" -s q -l quiet -d 'Quiet mode - suppress diagnostic messages'
complete -c asciinema -n "__fish_asciinema_using_subcommand convert" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c asciinema -n "__fish_asciinema_using_subcommand help; and not __fish_seen_subcommand_from record stream session play upload auth cat convert help" -f -a "record" -d 'Record a terminal session'
complete -c asciinema -n "__fish_asciinema_using_subcommand help; and not __fish_seen_subcommand_from record stream session play upload auth cat convert help" -f -a "stream" -d 'Stream a terminal session'
complete -c asciinema -n "__fish_asciinema_using_subcommand help; and not __fish_seen_subcommand_from record stream session play upload auth cat convert help" -f -a "session" -d 'Record and stream a terminal session'
complete -c asciinema -n "__fish_asciinema_using_subcommand help; and not __fish_seen_subcommand_from record stream session play upload auth cat convert help" -f -a "play" -d 'Play back a terminal session'
complete -c asciinema -n "__fish_asciinema_using_subcommand help; and not __fish_seen_subcommand_from record stream session play upload auth cat convert help" -f -a "upload" -d 'Upload a recording to an asciinema server'
complete -c asciinema -n "__fish_asciinema_using_subcommand help; and not __fish_seen_subcommand_from record stream session play upload auth cat convert help" -f -a "auth" -d 'Authenticate this CLI with an asciinema server account'
complete -c asciinema -n "__fish_asciinema_using_subcommand help; and not __fish_seen_subcommand_from record stream session play upload auth cat convert help" -f -a "cat" -d 'Concatenate multiple recordings'
complete -c asciinema -n "__fish_asciinema_using_subcommand help; and not __fish_seen_subcommand_from record stream session play upload auth cat convert help" -f -a "convert" -d 'Convert a recording to another format'
complete -c asciinema -n "__fish_asciinema_using_subcommand help; and not __fish_seen_subcommand_from record stream session play upload auth cat convert help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
