"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TextLink = exports.textLinkStyle = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
const Link_1 = require("./Link");
const colors_v2_1 = require("../Identity/colors-v2");
const textLinkStyle = (theme, _a) => {
    var { color = colors_v2_1.COLOR_V2.BLUE, fontSize = theme.fontSizes.base, bold = false, textTransform = 'none' } = _a, props = __rest(_a, ["color", "fontSize", "bold", "textTransform"]);
    return (Object.assign({}, (0, Link_1.linkStyle)(theme, Object.assign({ bold, color, fontSize, textTransform }, props))));
};
exports.textLinkStyle = textLinkStyle;
const TextLink = (props) => ((0, jsx_runtime_1.jsx)("a", Object.assign({ css: (theme) => (0, exports.textLinkStyle)(theme, props), rel: "noopener noreferrer" }, (0, Link_1.filterLinkProps)(props))));
exports.TextLink = TextLink;
