/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import net.sourceforge.plantuml.klimt.LineBreakStrategy;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.creole.Sheet;
import net.sourceforge.plantuml.klimt.creole.SheetBlock1;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.sprite.SpriteContainerEmpty;
import net.sourceforge.plantuml.project.GanttConstraint;
import net.sourceforge.plantuml.project.LabelStrategy;
import net.sourceforge.plantuml.project.ToTaskDraw;
import net.sourceforge.plantuml.project.core.GArrowType;
import net.sourceforge.plantuml.project.core.GSide;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.core.TaskImpl;
import net.sourceforge.plantuml.project.draw.AbstractTaskDraw;
import net.sourceforge.plantuml.project.draw.FingerPrint;
import net.sourceforge.plantuml.project.draw.RectangleTask;
import net.sourceforge.plantuml.project.lang.CenterBorderColor;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.graphic.Segment;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.style.ISkinSimple;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.image.Opale;

public class TaskDrawRegular
extends AbstractTaskDraw {
    private final Day end;
    private final boolean oddStart;
    private final boolean oddEnd;
    private final Collection<Day> paused;
    private final Collection<GanttConstraint> constraints;
    private final ISkinSimple skinSimple;

    public TaskDrawRegular(TimeScale timeScale, Real y, String prettyDisplay, Day start, Day end, boolean oddStart, boolean oddEnd, ISkinSimple skinSimple, Task task, ToTaskDraw toTaskDraw, Collection<GanttConstraint> constraints, StyleBuilder styleBuilder) {
        super(timeScale, y, prettyDisplay, start, task, toTaskDraw, styleBuilder);
        this.skinSimple = skinSimple;
        this.constraints = constraints;
        this.end = end;
        this.oddStart = oddStart;
        this.oddEnd = oddEnd;
        this.paused = new TreeSet<Day>(((TaskImpl)task).getAllPaused());
        Day tmp = start;
        while (tmp.compareTo(end) <= 0) {
            int load = ((TaskImpl)task).getDefaultPlan().getLoadAt(tmp);
            if (load == 0) {
                this.paused.add(tmp);
            }
            tmp = tmp.increment();
        }
    }

    @Override
    public double getShapeHeight(StringBounder stringBounder) {
        Style style = this.getStyle();
        ClockwiseTopRightBottomLeft padding = style.getPadding();
        return padding.getTop() + this.getTitle().calculateDimension(stringBounder).getHeight() + padding.getBottom();
    }

    @Override
    public void drawTitle(UGraphic ug, LabelStrategy labelStrategy, double colTitles, double colBars) {
        TextBlock title = this.getTitle();
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dim = title.calculateDimension(stringBounder);
        Style style = this.getStyleSignature().getMergedStyle(this.getStyleBuilder());
        ClockwiseTopRightBottomLeft margin = style.getMargin();
        ClockwiseTopRightBottomLeft padding = style.getPadding();
        ug = ug.apply(UTranslate.dy(margin.getTop() + padding.getTop()));
        if (labelStrategy.titleInFirstColumn()) {
            if (labelStrategy.rightAligned()) {
                title.drawU(ug.apply(UTranslate.dx(colTitles - dim.getWidth() - margin.getRight())));
            } else {
                title.drawU(ug.apply(UTranslate.dx(margin.getLeft())));
            }
            return;
        }
        if (labelStrategy.titleInLastColumn()) {
            title.drawU(ug.apply(UTranslate.dx(colBars + margin.getLeft())));
            return;
        }
        double pos1 = this.timeScale.getStartingPosition(this.start) + 6.0;
        double pos2 = this.timeScale.getEndingPosition(this.end) - 6.0;
        double pos = pos2 - pos1 > dim.getWidth() ? pos1 : this.getOutPosition(pos2);
        title.drawU(ug.apply(UTranslate.dx(pos)));
    }

    @Override
    protected TextBlock getTitle() {
        return Display.getWithNewlines(this.getPragma(), this.prettyDisplay).create(this.getFontConfiguration(), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
    }

    private double getOutPosition(double pos2) {
        if (this.isThereRightArrow()) {
            return pos2 + 18.0;
        }
        return pos2 + 8.0;
    }

    private boolean isThereRightArrow() {
        for (GanttConstraint constraint : this.constraints) {
            if (!constraint.isThereRightArrow(this.getTask())) continue;
            return true;
        }
        return false;
    }

    @Override
    StyleSignature getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.ganttDiagram, SName.task).withTOBECHANGED(this.getTask().getStereotype());
    }

    @Override
    public void drawU(UGraphic ug) {
        double startPos = this.timeScale.getStartingPosition(this.start);
        this.drawNote(ug.apply(new UTranslate(startPos, this.getYNotePosition(ug.getStringBounder()))));
        this.drawShape(ug);
    }

    private double getYNotePosition(StringBounder stringBounder) {
        Style style = this.getStyle();
        ClockwiseTopRightBottomLeft margin = style.getMargin();
        return margin.getTop() + this.getShapeHeight(stringBounder) + margin.getBottom();
    }

    private void drawNote(UGraphic ug) {
        if (this.note == null) {
            return;
        }
        this.getOpaleNote().drawU(ug);
    }

    @Override
    public double getHeightMax(StringBounder stringBounder) {
        if (this.note == null) {
            return this.getFullHeightTask(stringBounder);
        }
        return this.getYNotePosition(stringBounder) + this.getOpaleNote().calculateDimension(stringBounder).getHeight();
    }

    private Opale getOpaleNote() {
        Style style = StyleSignatureBasic.of(SName.root, SName.element, SName.ganttDiagram, SName.note).withTOBECHANGED(this.noteStereotype).getMergedStyle(this.getStyleBuilder());
        FontConfiguration fc = style.getFontConfiguration(this.getColorSet());
        HorizontalAlignment horizontalAlignment = style.value(PName.HorizontalAlignment).asHorizontalAlignment();
        Sheet sheet = this.skinSimple.sheet(fc, horizontalAlignment, CreoleMode.FULL).createSheet(this.note);
        double padding = style.value(PName.Padding).asDouble();
        SheetBlock1 sheet1 = new SheetBlock1(sheet, LineBreakStrategy.NONE, padding);
        HColor noteBackgroundColor = style.value(PName.BackGroundColor).asColor(this.getColorSet());
        HColor borderColor = style.value(PName.LineColor).asColor(this.getColorSet());
        double shadowing = style.getShadowing();
        return new Opale(shadowing, borderColor, noteBackgroundColor, sheet1, false, style.getStroke());
    }

    @Override
    public FingerPrint getFingerPrint(StringBounder stringBounder) {
        double h2 = this.getFullHeightTask(stringBounder);
        double startPos = this.timeScale.getStartingPosition(this.start);
        double endPos = this.timeScale.getEndingPosition(this.end);
        return new FingerPrint(startPos, this.getY(stringBounder).getCurrentValue(), endPos - startPos, h2);
    }

    @Override
    public FingerPrint getFingerPrintNote(StringBounder stringBounder) {
        if (this.note == null) {
            return null;
        }
        XDimension2D dim = this.getOpaleNote().calculateDimension(stringBounder);
        double startPos = this.timeScale.getStartingPosition(this.start);
        return new FingerPrint(startPos, this.getY(stringBounder).getCurrentValue() + this.getYNotePosition(stringBounder), dim.getWidth(), dim.getHeight());
    }

    private UGraphic applyColors(UGraphic ug) {
        CenterBorderColor col = this.getColors();
        if (col != null && col.isOk()) {
            return col.apply(ug);
        }
        return ug.apply(this.getLineColor()).apply(this.getBackgroundColor().bg());
    }

    @Override
    public double getX(StringBounder stringBounder, GSide side, GArrowType arrowType) {
        double x;
        if (side == GSide.LEFT) {
            x = this.timeScale.getStartingPosition(this.start);
        } else if (side == GSide.RIGHT) {
            x = this.timeScale.getEndingPosition(this.end);
        } else if (side == GSide.TOP_LEFT || side == GSide.BOTTOM_LEFT) {
            x = this.timeScale.getStartingPosition(this.start) + 8.0;
            if (x > this.timeScale.getStartingPosition(this.end)) {
                x = (this.timeScale.getStartingPosition(this.start) + this.timeScale.getEndingPosition(this.start)) / 2.0;
            }
        } else if (side == GSide.TOP_RIGHT || side == GSide.BOTTOM_RIGHT) {
            x = this.timeScale.getEndingPosition(this.end) - 8.0;
            if (x < this.timeScale.getEndingPosition(this.start)) {
                x = (this.timeScale.getStartingPosition(this.end) + this.timeScale.getEndingPosition(this.end)) / 2.0;
            }
        } else {
            throw new IllegalArgumentException();
        }
        if (arrowType == GArrowType.OUTGOING) {
            Style style = this.getStyleSignature().getMergedStyle(this.getStyleBuilder());
            ClockwiseTopRightBottomLeft margin = style.getMargin();
            if (side == GSide.LEFT) {
                x += margin.getLeft();
            } else if (side == GSide.RIGHT) {
                x -= margin.getLeft();
            }
        }
        return x;
    }

    public void drawShape(UGraphic ug) {
        ug = this.applyColors(ug);
        Style style = this.getStyleSignature().getMergedStyle(this.getStyleBuilder());
        ClockwiseTopRightBottomLeft margin = style.getMargin();
        double startPos = this.timeScale.getStartingPosition(this.start) + margin.getLeft();
        double endPos = this.timeScale.getEndingPosition(this.end) - margin.getRight();
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        ug = ug.apply(UTranslate.dy(margin.getTop()));
        StringBounder stringBounder = ug.getStringBounder();
        double round = style.value(PName.RoundCorner).asDouble();
        ArrayList<Segment> off = new ArrayList<Segment>();
        for (Day pause : this.paused) {
            double x1 = this.timeScale.getStartingPosition(pause);
            double x2 = this.timeScale.getEndingPosition(pause);
            off.add(new Segment(x1, x2));
        }
        HColor backUndone = StyleSignatureBasic.of(SName.root, SName.element, SName.ganttDiagram, SName.undone).getMergedStyle(this.getStyleBuilder()).value(PName.BackGroundColor).asColor(this.getColorSet());
        RectangleTask rectangleTask = new RectangleTask(startPos, endPos, round, this.getCompletion(), off);
        rectangleTask.draw(ug, this.getShapeHeight(stringBounder), backUndone, this.oddStart, this.oddEnd);
        if (this.url != null) {
            ug.closeUrl();
        }
    }
}

