/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.derivedsource;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.util.IOUtils;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.knn.index.codec.derivedsource.DerivedSourceReaders;
import org.opensearch.knn.index.codec.derivedsource.PerFieldDerivedVectorInjector;
import org.opensearch.knn.index.codec.derivedsource.PerFieldDerivedVectorInjectorFactory;

public class DerivedSourceVectorInjector
implements Closeable {
    @Generated
    private static final Logger log = LogManager.getLogger(DerivedSourceVectorInjector.class);
    private final DerivedSourceReaders derivedSourceReaders;
    private final List<PerFieldDerivedVectorInjector> perFieldDerivedVectorInjectors;
    private final Set<String> fieldNames;

    public DerivedSourceVectorInjector(DerivedSourceReaders derivedSourceReaders, SegmentReadState segmentReadState, List<FieldInfo> fieldsToInjectVector) {
        this.derivedSourceReaders = derivedSourceReaders;
        this.perFieldDerivedVectorInjectors = new ArrayList<PerFieldDerivedVectorInjector>();
        this.fieldNames = new HashSet<String>();
        for (FieldInfo fieldInfo : fieldsToInjectVector) {
            this.perFieldDerivedVectorInjectors.add(PerFieldDerivedVectorInjectorFactory.create(fieldInfo, derivedSourceReaders, segmentReadState));
            this.fieldNames.add(fieldInfo.name);
        }
    }

    public byte[] injectVectors(int docId, byte[] sourceAsBytes) throws IOException {
        Tuple mapTuple = XContentHelper.convertToMap((BytesReference)BytesReference.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(sourceAsBytes)), (boolean)true, (MediaType)MediaTypeRegistry.getDefaultMediaType());
        HashMap<String, Object> sourceAsMap = new HashMap<String, Object>((Map)mapTuple.v2());
        for (PerFieldDerivedVectorInjector vectorInjector : this.perFieldDerivedVectorInjectors) {
            vectorInjector.inject(docId, sourceAsMap);
        }
        BytesStreamOutput bStream = new BytesStreamOutput(1024);
        MediaType actualContentType = (MediaType)mapTuple.v1();
        XContentBuilder builder = MediaTypeRegistry.contentBuilder((MediaType)actualContentType, (OutputStream)bStream).map(sourceAsMap);
        builder.close();
        return BytesReference.toBytes((BytesReference)BytesReference.bytes((XContentBuilder)builder));
    }

    public boolean shouldInject(String[] includes, String[] excludes) {
        if (includes != null && includes != Strings.EMPTY_ARRAY) {
            for (String includedField : includes) {
                if (!this.fieldNames.contains(includedField)) continue;
                return true;
            }
        }
        if (excludes != null && excludes != Strings.EMPTY_ARRAY) {
            int excludedVectorFieldCount = 0;
            for (String excludedField : excludes) {
                if (!this.fieldNames.contains(excludedField)) continue;
                ++excludedVectorFieldCount;
            }
            return excludedVectorFieldCount < this.fieldNames.size();
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.derivedSourceReaders});
    }
}

