/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.affinity;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.util.BitSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import mediathek.tool.affinity.IAffinity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \b2\u00020\u0001:\u0002\u0007\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lmediathek/tool/affinity/WindowsAffinity;", "Lmediathek/tool/affinity/IAffinity;", "()V", "setDesiredCpuAffinity", "", "numCpus", "", "AffinityKernel", "Companion", "MediathekView"})
public final class WindowsAffinity
implements IAffinity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger logger = LogManager.getLogger();

    @Override
    public void setDesiredCpuAffinity(int numCpus) {
        int pid = -1;
        BitSet bitSet = new BitSet();
        bitSet.set(0, numCpus);
        long affinity = bitSet.stream().takeWhile(WindowsAffinity::setDesiredCpuAffinity$lambda$0).mapToLong(WindowsAffinity::setDesiredCpuAffinity$lambda$1).reduce(0L, WindowsAffinity::setDesiredCpuAffinity$lambda$2);
        int affinityMask = (int)affinity;
        AffinityKernel instance = Native.load("Kernel32", AffinityKernel.class);
        boolean result = instance.SetProcessAffinityMask(new WinNT.HANDLE(new Pointer(pid)), affinityMask);
        if (result) {
            logger.info("CPU affinity was set successfully.");
            logger.trace("Available processors: {}", (Object)Runtime.getRuntime().availableProcessors());
        } else {
            logger.warn("Failed to set CPU affinity.");
        }
    }

    private static final boolean setDesiredCpuAffinity$lambda$0(int i) {
        return i < 64;
    }

    private static final long setDesiredCpuAffinity$lambda$1(int i) {
        return 1L << i;
    }

    private static final long setDesiredCpuAffinity$lambda$2(long a, long b) {
        return a | b;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\bb\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lmediathek/tool/affinity/WindowsAffinity$AffinityKernel;", "Lcom/sun/jna/platform/win32/Kernel32;", "SetProcessAffinityMask", "", "hProcess", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "dwProcessAffinityMask", "", "MediathekView"})
    private static interface AffinityKernel
    extends Kernel32 {
        public boolean SetProcessAffinityMask(@Nullable WinNT.HANDLE var1, int var2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lmediathek/tool/affinity/WindowsAffinity$Companion;", "", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

