/*
 * Decompiled with CFR 0.152.
 */
package mediathek.mainwindow;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import mediathek.gui.messages.DarkModeChangeEvent;
import mediathek.tool.MessageBus;
import net.engio.mbassy.listener.Handler;
import org.jetbrains.annotations.NotNull;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYSplineRenderer;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class MemoryUsagePanel
extends JPanel {
    private final TimeSeries total = new TimeSeries((Comparable)((Object)"Total Memory"));
    private final DateAxis domain = new DateAxis("Time");
    private final NumberAxis range = new NumberAxis("Memory");

    public MemoryUsagePanel(int maxAge, @NotNull TimeUnit timeUnit) {
        super(new BorderLayout());
        this.total.setMaximumItemAge(TimeUnit.MILLISECONDS.convert(maxAge, timeUnit));
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(this.total);
        this.range.setAutoRange(true);
        this.setLabelColors();
        XYSplineRenderer renderer = new XYSplineRenderer();
        renderer.setDefaultShapesVisible(false);
        renderer.setSeriesPaint(0, Color.red);
        XYPlot plot = new XYPlot(dataset, this.domain, this.range, renderer);
        plot.setBackgroundPaint(Color.BLACK);
        plot.setDomainGridlinePaint(Color.white);
        plot.setRangeGridlinePaint(Color.white);
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        this.domain.setAutoRange(true);
        this.domain.setLowerMargin(0.0);
        this.domain.setUpperMargin(0.0);
        this.domain.setTickLabelsVisible(true);
        this.range.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        this.range.setNumberFormatOverride(new DecimalFormat("#######.##"));
        JFreeChart chart = new JFreeChart(plot);
        chart.removeLegend();
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.addChartMouseListener(new GarbageCollectionMouseListener());
        chartPanel.setPopupMenu(null);
        this.add(chartPanel);
        MessageBus.getMessageBus().subscribe(this);
    }

    @Handler
    private void handleDarkModeChange(DarkModeChangeEvent e) {
        SwingUtilities.invokeLater(this::setLabelColors);
    }

    private void setLabelColors() {
        Color color = UIManager.getColor("Label.foreground");
        this.domain.setLabelPaint(color);
        this.domain.setTickLabelPaint(color);
        this.domain.setTickMarkPaint(color);
        this.range.setLabelPaint(color);
        this.range.setTickLabelPaint(color);
        this.range.setTickMarkPaint(color);
    }

    private void addTotalObservation(double y) {
        this.total.add((RegularTimePeriod)new Millisecond(), y);
    }

    private static class GarbageCollectionMouseListener
    implements ChartMouseListener {
        private GarbageCollectionMouseListener() {
        }

        @Override
        public void chartMouseClicked(ChartMouseEvent event) {
            System.gc();
        }

        @Override
        public void chartMouseMoved(ChartMouseEvent event) {
        }
    }

    public class MemoryUsageDataGenerator
    extends Timer
    implements ActionListener {
        public MemoryUsageDataGenerator(@NotNull int interval, TimeUnit timeUnit) {
            super((int)TimeUnit.MILLISECONDS.convert(interval, timeUnit), null);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            long t = Runtime.getRuntime().totalMemory() / 0x100000L;
            MemoryUsagePanel.this.addTotalObservation(t);
        }
    }
}

