/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.files.AbstractChangeWindowsRightsAction;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.helper.InstallerUtil;
import java.io.File;

public class AddWindowsFileRightsAction
extends AbstractChangeWindowsRightsAction {
    private File[] files;

    public File[] getFiles() {
        return this.replaceWithTextOverride("files", AddWindowsFileRightsAction.replaceVariables(this.files), File[].class);
    }

    public void setFiles(File[] files) {
        this.files = files;
    }

    @Override
    public boolean execute(Context context) throws UserCanceledException {
        if (!InstallerUtil.isWindows()) {
            return true;
        }
        File[] files = this.getFiles();
        if (files == null) {
            return true;
        }
        boolean success = true;
        for (File file : files) {
            success &= this.executeForSingleFile(context, file);
        }
        return success;
    }

    protected boolean executeForSingleFile(Context context, File file) throws UserCanceledException {
        File usedFile = context.getDestinationFile(file);
        if (usedFile == null || !usedFile.exists()) {
            return false;
        }
        return ContextImpl.getContextInt(context).runBooleanActivityWithFallback(new AbstractChangeWindowsRightsAction.ACERemoteCallable(usedFile.getAbsolutePath(), false, this.isRead(), this.isWrite(), this.isExecute(), this.isAll(), this.getGroup().getIntValue(), this.getUsedSidOrAccountName(), this.getAccessMode()));
    }

    @Override
    public boolean isRollbackSupported() {
        return false;
    }
}

