/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.appearance;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.gephi.appearance.api.AppearanceController;
import org.gephi.appearance.api.AppearanceModel;
import org.gephi.appearance.api.Function;
import org.gephi.appearance.spi.TransformerCategory;
import org.gephi.appearance.spi.TransformerUI;
import org.gephi.desktop.appearance.AppearanceUIModel;
import org.gephi.project.api.Workspace;
import org.gephi.project.spi.WorkspaceXMLPersistenceProvider;
import org.gephi.utils.Serialization;
import org.openide.util.Lookup;

public class AppearanceUIModelPersistenceProvider
implements WorkspaceXMLPersistenceProvider {
    public void writeXML(XMLStreamWriter writer, Workspace workspace) {
        AppearanceUIModel model = (AppearanceUIModel)workspace.getLookup().lookup(AppearanceUIModel.class);
        if (model != null) {
            try {
                this.writeXML(writer, model);
            }
            catch (XMLStreamException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void readXML(XMLStreamReader reader, Workspace workspace) {
        AppearanceUIModel model = (AppearanceUIModel)workspace.getLookup().lookup(AppearanceUIModel.class);
        AppearanceModel appearanceModel = (AppearanceModel)workspace.getLookup().lookup(AppearanceModel.class);
        if (appearanceModel == null) {
            AppearanceController appearanceController = (AppearanceController)Lookup.getDefault().lookup(AppearanceController.class);
            appearanceModel = appearanceController.getModel(workspace);
        }
        if (model == null) {
            model = new AppearanceUIModel(appearanceModel);
            workspace.add((Object)model);
        }
        try {
            this.readXML(reader, model);
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getIdentifier() {
        return "appearanceuimodel";
    }

    protected void writeXML(XMLStreamWriter writer, AppearanceUIModel model) throws XMLStreamException {
        this.writeSelected(writer, model);
        for (Map.Entry<Function, Map<String, Object>> savedProperty : model.savedProperties.entrySet()) {
            writer.writeStartElement("savedproperty");
            writer.writeAttribute("function", savedProperty.getKey().getId());
            this.writeSavedProperty(writer, savedProperty.getValue());
            writer.writeEndElement();
        }
    }

    private void writeSelected(XMLStreamWriter writer, AppearanceUIModel model) throws XMLStreamException {
        writer.writeStartElement("selected");
        writer.writeAttribute("elementClass", model.getSelectedElementClass());
        writer.writeEndElement();
        for (String elementClass : model.getElementClasses()) {
            writer.writeStartElement("selected");
            writer.writeAttribute("elementClass", elementClass);
            writer.writeAttribute("category", model.getSelectedCategory(elementClass).getId());
            writer.writeEndElement();
        }
        for (String elementClass : model.getElementClasses()) {
            for (TransformerCategory transformerCategory : model.getTransformerCategories(elementClass)) {
                TransformerUI transformerUI = model.getTransformerUI(elementClass, transformerCategory);
                writer.writeStartElement("selected");
                writer.writeAttribute("elementClass", elementClass);
                writer.writeAttribute("ui", transformerUI.getClass().getName());
                Function function = model.getFunction(elementClass, transformerUI);
                if (function != null) {
                    writer.writeAttribute("function", function.getId());
                }
                writer.writeEndElement();
            }
        }
    }

    private void writeSavedProperty(XMLStreamWriter writer, Map<String, Object> savedProperty) throws XMLStreamException {
        for (Map.Entry<String, Object> entry : savedProperty.entrySet()) {
            String valueTxt = Serialization.getValueAsText((Object)entry.getValue());
            if (valueTxt == null) continue;
            writer.writeStartElement("property");
            writer.writeAttribute("key", entry.getKey());
            writer.writeAttribute("value", Serialization.getValueAsText((Object)entry.getValue()));
            writer.writeAttribute("type", entry.getValue().getClass().getName());
            writer.writeEndElement();
        }
    }

    public void readXML(XMLStreamReader reader, AppearanceUIModel model) throws XMLStreamException {
        AppearanceModel appearanceModel = model.appearanceModel;
        Function[] functions = (Function[])Stream.concat(Arrays.stream(appearanceModel.getNodeFunctions()), Arrays.stream(appearanceModel.getEdgeFunctions())).toArray(Function[]::new);
        Function function = null;
        HashMap properties = null;
        boolean end = false;
        while (reader.hasNext() && !end) {
            Integer eventType = reader.next();
            if (eventType.equals(1)) {
                String name = reader.getLocalName();
                if ("savedproperty".equalsIgnoreCase(name)) {
                    String functionName = reader.getAttributeValue(null, "function");
                    function = Arrays.stream(functions).filter(f -> f.getId().equals(functionName)).findFirst().orElse(null);
                    properties = new HashMap();
                    continue;
                }
                if ("property".equalsIgnoreCase(name) && function != null) {
                    this.readSavedProperty(reader, properties);
                    continue;
                }
                if (!"selected".equalsIgnoreCase(name)) continue;
                this.readSelected(reader, model);
                continue;
            }
            if (!eventType.equals(2)) continue;
            if ("savedproperty".equalsIgnoreCase(reader.getLocalName()) && function != null) {
                model.savedProperties.put(function, properties);
                function = null;
                properties = null;
                continue;
            }
            if (!this.getIdentifier().equalsIgnoreCase(reader.getLocalName())) continue;
            end = true;
        }
    }

    private void readSelected(XMLStreamReader reader, AppearanceUIModel model) {
        String elementClass = reader.getAttributeValue(null, "elementClass");
        String category = reader.getAttributeValue(null, "category");
        String ui = reader.getAttributeValue(null, "ui");
        String function = reader.getAttributeValue(null, "function");
        model.setSelected(elementClass, category, ui, function);
    }

    private void readSavedProperty(XMLStreamReader reader, Map<String, Object> map) throws XMLStreamException {
        String type;
        String key = reader.getAttributeValue(null, "key");
        String value = reader.getAttributeValue(null, "value");
        Object val = Serialization.readValueFromText((String)value, (String)(type = reader.getAttributeValue(null, "type")));
        if (val != null) {
            map.put(key, val);
        }
    }
}

