#
# -*- coding: utf-8 -*-
# Copyright 2019 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function


__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################
"""
The arg spec for the vyos_ospfv2 module
"""


class Ospfv2Args(object):  # pylint: disable=R0903
    """The arg spec for the vyos_ospfv2 module"""

    def __init__(self, **kwargs):
        pass

    argument_spec = {
        "config": {
            "options": {
                "auto_cost": {
                    "options": {"reference_bandwidth": {"type": "int"}},
                    "type": "dict",
                },
                "default_information": {
                    "options": {
                        "originate": {
                            "options": {
                                "always": {"type": "bool"},
                                "metric": {"type": "int"},
                                "metric_type": {"type": "int"},
                                "route_map": {"type": "str"},
                            },
                            "type": "dict",
                        },
                    },
                    "type": "dict",
                },
                "default_metric": {"type": "int"},
                "distance": {
                    "options": {
                        "global": {"type": "int"},
                        "ospf": {
                            "options": {
                                "external": {"type": "int"},
                                "inter_area": {"type": "int"},
                                "intra_area": {"type": "int"},
                            },
                            "type": "dict",
                        },
                    },
                    "type": "dict",
                },
                "log_adjacency_changes": {
                    "choices": ["detail"],
                    "type": "str",
                },
                "max_metric": {
                    "options": {
                        "router_lsa": {
                            "options": {
                                "administrative": {"type": "bool"},
                                "on_shutdown": {"type": "int"},
                                "on_startup": {"type": "int"},
                            },
                            "type": "dict",
                        },
                    },
                    "type": "dict",
                },
                "mpls_te": {
                    "options": {
                        "enabled": {"type": "bool"},
                        "router_address": {"type": "str"},
                    },
                    "type": "dict",
                },
                "neighbor": {
                    "elements": "dict",
                    "options": {
                        "neighbor_id": {"type": "str"},
                        "poll_interval": {"type": "int"},
                        "priority": {"type": "int"},
                    },
                    "type": "list",
                },
                "areas": {
                    "elements": "dict",
                    "options": {
                        "area_id": {"type": "str"},
                        "area_type": {
                            "options": {
                                "normal": {"type": "bool"},
                                "nssa": {
                                    "options": {
                                        "default_cost": {"type": "int"},
                                        "no_summary": {"type": "bool"},
                                        "set": {"type": "bool"},
                                        "translate": {
                                            "choices": [
                                                "always",
                                                "candidate",
                                                "never",
                                            ],
                                            "type": "str",
                                        },
                                    },
                                    "type": "dict",
                                },
                                "stub": {
                                    "options": {
                                        "default_cost": {"type": "int"},
                                        "no_summary": {"type": "bool"},
                                        "set": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                            },
                            "type": "dict",
                        },
                        "authentication": {
                            "choices": ["plaintext-password", "md5"],
                            "type": "str",
                        },
                        "network": {
                            "elements": "dict",
                            "options": {"address": {"required": True, "type": "str"}},
                            "type": "list",
                        },
                        "range": {
                            "elements": "dict",
                            "options": {
                                "address": {"type": "str"},
                                "cost": {"type": "int"},
                                "not_advertise": {"type": "bool"},
                                "substitute": {"type": "str"},
                            },
                            "type": "list",
                        },
                        "shortcut": {
                            "choices": ["default", "disable", "enable"],
                            "type": "str",
                        },
                        "virtual_link": {
                            "elements": "dict",
                            "options": {
                                "address": {"type": "str"},
                                "authentication": {
                                    "options": {
                                        "md5": {
                                            "elements": "dict",
                                            "options": {
                                                "key_id": {"type": "int"},
                                                "md5_key": {
                                                    "type": "str",
                                                    "no_log": True,
                                                },
                                            },
                                            "type": "list",
                                        },
                                        "plaintext_password": {
                                            "type": "str",
                                            "no_log": True,
                                        },
                                    },
                                    "type": "dict",
                                },
                                "dead_interval": {"type": "int"},
                                "hello_interval": {"type": "int"},
                                "retransmit_interval": {"type": "int"},
                                "transmit_delay": {"type": "int"},
                            },
                            "type": "list",
                        },
                    },
                    "type": "list",
                },
                "parameters": {
                    "options": {
                        "abr_type": {
                            "choices": [
                                "cisco",
                                "ibm",
                                "shortcut",
                                "standard",
                            ],
                            "type": "str",
                        },
                        "opaque_lsa": {"type": "bool"},
                        "rfc1583_compatibility": {"type": "bool"},
                        "router_id": {"type": "str"},
                    },
                    "type": "dict",
                },
                "passive_interface": {"type": "list", "elements": "str"},
                "passive_interface_exclude": {
                    "type": "list",
                    "elements": "str",
                },
                "redistribute": {
                    "elements": "dict",
                    "options": {
                        "metric": {"type": "int"},
                        "metric_type": {"type": "int"},
                        "route_map": {"type": "str"},
                        "route_type": {
                            "choices": [
                                "bgp",
                                "connected",
                                "kernel",
                                "rip",
                                "static",
                            ],
                            "type": "str",
                        },
                    },
                    "type": "list",
                },
                "route_map": {"type": "list", "elements": "str"},
                "timers": {
                    "options": {
                        "refresh": {
                            "options": {"timers": {"type": "int"}},
                            "type": "dict",
                        },
                        "throttle": {
                            "options": {
                                "spf": {
                                    "options": {
                                        "delay": {"type": "int"},
                                        "initial_holdtime": {"type": "int"},
                                        "max_holdtime": {"type": "int"},
                                    },
                                    "type": "dict",
                                },
                            },
                            "type": "dict",
                        },
                    },
                    "type": "dict",
                },
            },
            "type": "dict",
        },
        "running_config": {"type": "str"},
        "state": {
            "choices": [
                "merged",
                "replaced",
                "deleted",
                "parsed",
                "gathered",
                "rendered",
            ],
            "default": "merged",
            "type": "str",
        },
    }  # pylint: disable=C0301
