"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MenuItem = exports.MenuModal = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
const Identity_1 = require("../Identity/");
const motions_1 = require("../Identity/motions");
const mediaQueries_1 = require("../mediaQueries");
const Overlay_1 = require("../Modal/Overlay");
const util_1 = require("../util");
const menuModalWrapperStyle = props => (Object.assign(Object.assign({}, (0, Overlay_1.overlayBackgroundStyle)(props)), { alignItems: 'flex-end', alignSelf: 'flex-end', display: 'flex', overflowY: 'hidden', padding: 0 }));
const MenuModalWrapper = (props) => (0, jsx_runtime_1.jsx)("div", Object.assign({ css: menuModalWrapperStyle }, props));
const MenuModalBody = (props) => ((0, jsx_runtime_1.jsx)("div", Object.assign({ css: (theme) => ({
        animation: `${motions_1.ANIMATION.bottomUpMovement} ${motions_1.DURATION.DEFAULT}ms ${motions_1.EASE.EXPONENTIAL}`,
        backgroundColor: Identity_1.COLOR.tint(theme.general.backgroundColor, 0.16),
        boxShadow: '0 16px 64px 0 rgba(0, 0, 0, 0.16)',
        display: 'flex',
        flexDirection: 'column',
        justifyContent: 'space-between',
        marginLeft: 'auto',
        marginRight: 'auto',
        padding: '8px 16px',
        position: 'relative',
        width: '767px',
        zIndex: 9999,
        [mediaQueries_1.media[mediaQueries_1.QueryKeys.TABLET_DOWN]]: {
            width: '100%',
        },
    }) }, props)));
const MenuModalContent = (props) => ((0, jsx_runtime_1.jsx)("ul", Object.assign({ css: {
        li: {
            borderBottom: `1px solid ${Identity_1.COLOR.GRAY_LIGHTEN_72}`,
        },
        'li:last-child': {
            borderBottom: 0,
        },
        margin: 0,
        maxWidth: '100%',
        minWidth: '100%',
        padding: 0,
    } }, props)));
const modalBackgroundStyle = props => (Object.assign(Object.assign({}, (0, Overlay_1.overlayBackgroundStyle)(props)), { background: 'rgba(50, 54, 57, 0.4)' }));
const MenuModalBackground = (props) => (0, jsx_runtime_1.jsx)("div", Object.assign({ css: modalBackgroundStyle }, props));
const MenuModal = (_a) => {
    var { children = null, onBackgroundClick = util_1.noop } = _a, props = __rest(_a, ["children", "onBackgroundClick"]);
    return ((0, jsx_runtime_1.jsxs)(MenuModalWrapper, Object.assign({}, props, { children: [(0, jsx_runtime_1.jsx)(MenuModalBody, { children: (0, jsx_runtime_1.jsx)(MenuModalContent, { children: children }) }), (0, jsx_runtime_1.jsx)(MenuModalBackground, { onClick: onBackgroundClick, "data-uie-name": "menu-background" })] })));
};
exports.MenuModal = MenuModal;
const MenuItem = (_a) => {
    var { children = null } = _a, props = __rest(_a, ["children"]);
    return ((0, jsx_runtime_1.jsx)("li", Object.assign({ css: (theme) => ({
            alignItems: 'center',
            color: theme.general.color,
            cursor: 'pointer',
            display: 'flex',
            height: '56px',
            listStyleType: 'none',
            maxWidth: '100%',
        }) }, props, { children: children })));
};
exports.MenuItem = MenuItem;
