/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.visualvm.lib.common.ProfilingSettings;
import org.graalvm.visualvm.lib.profiler.Bundle;
import org.graalvm.visualvm.lib.profiler.ResultsManager;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.graalvm.visualvm.lib.profiler.api.ProfilerIDESettings;
import org.graalvm.visualvm.lib.profiler.api.ProfilerStorage;
import org.graalvm.visualvm.lib.profiler.spi.SessionListener;
import org.graalvm.visualvm.lib.profiler.v2.SnapshotsWindow;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class HeapDumpWatch
extends SessionListener.Adapter {
    private static final Logger LOG = Logger.getLogger(HeapDumpWatch.class.getName());
    private FileObject monitoredPath;
    private HeapDumpFolderListener listener = new HeapDumpFolderListener();

    public static String getHeapDumpPath(Lookup.Provider project) {
        ProfilerIDESettings gps = ProfilerIDESettings.getInstance();
        if (!gps.isOOMDetectionEnabled()) {
            return null;
        }
        int oomeDetectionMode = gps.getOOMDetectionMode();
        switch (oomeDetectionMode) {
            case 2: {
                return System.getProperty("java.io.tmpdir");
            }
            case 1: {
                try {
                    return FileUtil.toFile((FileObject)ProfilerStorage.getProjectFolder((Lookup.Provider)project, (boolean)true)).getAbsolutePath();
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "Cannot resolve project settings directory:\n" + e.getMessage(), e);
                    return null;
                }
            }
            case 3: {
                return gps.getCustomHeapdumpPath();
            }
        }
        return null;
    }

    public void onShutdown() {
        this.release();
    }

    public void onStartup(ProfilingSettings ps, Lookup.Provider p) {
        String oomePath;
        if (ProfilerIDESettings.getInstance().isOOMDetectionEnabled() && (oomePath = HeapDumpWatch.getHeapDumpPath(p)) != null) {
            this.monitor(oomePath);
        }
    }

    private void monitor(String path) throws IllegalArgumentException {
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("The path \"" + path + "\" can't be null.");
        }
        FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(path)));
        if (fo != null) {
            if (!fo.isFolder()) {
                throw new IllegalArgumentException("The given path \"" + path + "\" is invalid. It must be a folder");
            }
            fo.getChildren();
            fo.addFileChangeListener((FileChangeListener)this.listener);
            this.monitoredPath = fo;
        }
    }

    private void captureHeapDump(FileObject heapDump) {
        if (!heapDump.getExt().equals("hprof")) {
            return;
        }
        if (heapDump.getName().startsWith("heapdump-")) {
            return;
        }
        SnapshotsWindow.instance().refreshFolder(heapDump.getParent(), true);
        try {
            if (ProfilerDialogs.displayConfirmation((String)Bundle.HeapDumpWatch_OOME_PROTECTION_OPEN_HEAPDUMP())) {
                ResultsManager.getDefault().openSnapshot(heapDump);
            } else if (ProfilerDialogs.displayConfirmation((String)Bundle.HeapDumpWatch_OOME_PROTECTION_REMOVE_HEAPDUMP())) {
                heapDump.delete();
                SnapshotsWindow.instance().refreshFolder(heapDump.getParent(), true);
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            this.release();
        }
    }

    private void release() {
        if (this.monitoredPath != null) {
            this.monitoredPath.removeFileChangeListener((FileChangeListener)this.listener);
            this.monitoredPath = null;
        }
    }

    private class HeapDumpFolderListener
    extends FileChangeAdapter {
        private HeapDumpFolderListener() {
        }

        public void fileDataCreated(FileEvent fileEvent) {
            HeapDumpWatch.this.captureHeapDump(fileEvent.getFile());
        }
    }
}

