/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.progress.spi;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.modules.progress.spi.Controller;
import org.netbeans.modules.progress.spi.ProgressUIWorker;
import org.netbeans.modules.progress.spi.ProgressUIWorkerProvider;
import org.netbeans.modules.progress.spi.ProgressUIWorkerWithModel;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class SwingController
extends Controller
implements Executor,
Runnable {
    private static final SwingController INSTANCE = new SwingController(null);
    private static final int TIMER_QUANTUM = 400;
    final Timer timer = new Timer(400, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SwingController.this.runNow();
        }
    });
    static final Method compatInit;

    public SwingController(ProgressUIWorker progressUIWorker) {
        super(progressUIWorker);
        this.timer.setRepeats(false);
        SwingController.runCompatInit(this);
    }

    protected Executor getEventExecutor() {
        return this;
    }

    protected void runEvents() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.runNow();
        } else {
            this.execute(this);
        }
    }

    @Override
    public void run() {
        this.runNow();
    }

    @Override
    public void execute(final Runnable runnable) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                runnable.run();
            }
        });
    }

    protected void resetTimer(int n, boolean bl) {
        if (n > 0) {
            this.timer.setInitialDelay(n);
            if (bl) {
                this.timer.restart();
            }
        } else {
            this.timer.stop();
        }
    }

    public static SwingController getDefault() {
        return INSTANCE;
    }

    public Component getVisualComponent() {
        ProgressUIWorker progressUIWorker = this.getProgressUIWorker();
        if (progressUIWorker instanceof Component) {
            return (Component)progressUIWorker;
        }
        return null;
    }

    protected ProgressUIWorkerWithModel createWorker() {
        return ((ProgressUIWorkerProvider)Lookup.getDefault().lookup(ProgressUIWorkerProvider.class)).getDefaultWorker();
    }

    protected Timer getTimer() {
        return this.timer;
    }

    private static void runCompatInit(SwingController swingController) {
        if (compatInit != null) {
            try {
                compatInit.invoke((Object)swingController, swingController.timer);
            }
            catch (IllegalAccessException illegalAccessException) {
                Exceptions.printStackTrace((Throwable)illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Exceptions.printStackTrace((Throwable)illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Exceptions.printStackTrace((Throwable)invocationTargetException);
            }
        }
    }

    static {
        Class clazz = SwingController.class.getSuperclass().getSuperclass();
        Method method = null;
        try {
            method = clazz.getDeclaredMethod("compatPostInit", Timer.class);
            method.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            Exceptions.printStackTrace((Throwable)securityException);
        }
        compatInit = method;
    }
}

