/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.util.HashSet;
import java.util.Set;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;
import org.openide.windows.WindowManager;

final class OnShowingHandler
implements LookupListener,
Runnable {
    private final Set<String> onShowing = new HashSet<String>();
    private final Lookup lkpShowing;
    private final WindowManager wm;
    private Lookup.Result<Runnable> resShow;

    OnShowingHandler(Lookup lookup, WindowManager windowManager) {
        this.lkpShowing = lookup;
        this.wm = windowManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize() {
        for (Lookup.Item item : this.onShowing().allItems()) {
            Set<String> set = this.onShowing;
            synchronized (set) {
                Runnable runnable;
                if (this.onShowing.add(item.getId()) && (runnable = (Runnable)item.getInstance()) != null) {
                    this.wm.invokeWhenUIReady(runnable);
                }
            }
        }
    }

    private synchronized Lookup.Result<Runnable> onShowing() {
        if (this.resShow == null) {
            Lookup lookup = this.lkpShowing != null ? this.lkpShowing : Lookups.forPath((String)"Modules/UIReady");
            this.resShow = lookup.lookupResult(Runnable.class);
            this.resShow.addLookupListener((LookupListener)this);
        }
        return this.resShow;
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.initialize();
    }

    @Override
    public void run() {
        this.initialize();
    }
}

