"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.paginateListStackSets = void 0;
const CloudFormationClient_1 = require("../CloudFormationClient");
const ListStackSetsCommand_1 = require("../commands/ListStackSetsCommand");
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new ListStackSetsCommand_1.ListStackSetsCommand(input), ...args);
};
async function* paginateListStackSets(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        input["MaxResults"] = config.pageSize;
        if (config.client instanceof CloudFormationClient_1.CloudFormationClient) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected CloudFormation | CloudFormationClient");
        }
        yield page;
        const prevToken = token;
        token = page.NextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
exports.paginateListStackSets = paginateListStackSets;
