/**
   @file utils.h
   @brief Utils

   <p>
   Copyright (C) 2009-2010 Nokia Corporation

   @author Timo Rongas <ext-timo.2.rongas@nokia.com>
   @author Serhii Tsyba <ext-serhii.2.tsyba@nokia.com>
   @author Shenghua <ext-shenghua.1.liu@nokia.com>

   This file is part of Sensord.

   Sensord is free software; you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License
   version 2.1 as published by the Free Software Foundation.

   Sensord is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with Sensord.  If not, see <http://www.gnu.org/licenses/>.
   </p>
 */

#ifndef UTILS_H
#define UTILS_H
#include <linux/input.h>

/**
 * Collection of static utility functions.
 */
class Utils
{
public:
    /**
     * Get timestamp of monotonic clock in microsecs.
     *
     * @return timestamp.
     */
    static quint64 getTimeStamp();

    /**
     * Convert given timeval struct into microsecs.
     *
     * @return timestamp.
     */
    static quint64 getTimeStamp(const struct input_event*);
};

#endif // UTILS_H
