/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.SpecialPermission;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.ActionFilter;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.network.NetworkService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.common.util.PageCacheRecycler;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.indices.breaker.CircuitBreakerService;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.discovery.Discovery;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.index.IndexModule;
import org.opensearch.index.shard.SearchOperationListener;
import org.opensearch.performanceanalyzer.OpenSearchResources;
import org.opensearch.performanceanalyzer.action.PerformanceAnalyzerActionFilter;
import org.opensearch.performanceanalyzer.collectors.AdmissionControlMetricsCollector;
import org.opensearch.performanceanalyzer.collectors.CacheConfigMetricsCollector;
import org.opensearch.performanceanalyzer.collectors.CircuitBreakerCollector;
import org.opensearch.performanceanalyzer.collectors.ClusterApplierServiceStatsCollector;
import org.opensearch.performanceanalyzer.collectors.ClusterManagerServiceEventMetrics;
import org.opensearch.performanceanalyzer.collectors.ClusterManagerServiceMetrics;
import org.opensearch.performanceanalyzer.collectors.ClusterManagerThrottlingMetricsCollector;
import org.opensearch.performanceanalyzer.collectors.ElectionTermCollector;
import org.opensearch.performanceanalyzer.collectors.FaultDetectionMetricsCollector;
import org.opensearch.performanceanalyzer.collectors.NodeDetailsCollector;
import org.opensearch.performanceanalyzer.collectors.NodeStatsAllShardsMetricsCollector;
import org.opensearch.performanceanalyzer.collectors.ShardIndexingPressureMetricsCollector;
import org.opensearch.performanceanalyzer.collectors.ShardStateCollector;
import org.opensearch.performanceanalyzer.collectors.ThreadPoolMetricsCollector;
import org.opensearch.performanceanalyzer.commons.OSMetricsGeneratorFactory;
import org.opensearch.performanceanalyzer.commons.collectors.DisksCollector;
import org.opensearch.performanceanalyzer.commons.collectors.GCInfoCollector;
import org.opensearch.performanceanalyzer.commons.collectors.HeapMetricsCollector;
import org.opensearch.performanceanalyzer.commons.collectors.NetworkInterfaceCollector;
import org.opensearch.performanceanalyzer.commons.collectors.OSMetricsCollector;
import org.opensearch.performanceanalyzer.commons.collectors.PerformanceAnalyzerMetricsCollector;
import org.opensearch.performanceanalyzer.commons.collectors.ScheduledMetricCollectorsExecutor;
import org.opensearch.performanceanalyzer.commons.collectors.StatsCollector;
import org.opensearch.performanceanalyzer.commons.config.PluginSettings;
import org.opensearch.performanceanalyzer.commons.config.overrides.ConfigOverridesWrapper;
import org.opensearch.performanceanalyzer.commons.event_process.EventLog;
import org.opensearch.performanceanalyzer.commons.event_process.EventLogFileHandler;
import org.opensearch.performanceanalyzer.config.PerformanceAnalyzerController;
import org.opensearch.performanceanalyzer.config.setting.ClusterSettingsManager;
import org.opensearch.performanceanalyzer.config.setting.PerformanceAnalyzerClusterSettings;
import org.opensearch.performanceanalyzer.config.setting.handler.ConfigOverridesClusterSettingHandler;
import org.opensearch.performanceanalyzer.config.setting.handler.NodeStatsSettingHandler;
import org.opensearch.performanceanalyzer.config.setting.handler.PerformanceAnalyzerClusterSettingHandler;
import org.opensearch.performanceanalyzer.http_action.config.PerformanceAnalyzerClusterConfigAction;
import org.opensearch.performanceanalyzer.http_action.config.PerformanceAnalyzerConfigAction;
import org.opensearch.performanceanalyzer.http_action.config.PerformanceAnalyzerOverridesClusterConfigAction;
import org.opensearch.performanceanalyzer.http_action.config.PerformanceAnalyzerResourceProvider;
import org.opensearch.performanceanalyzer.http_action.whoami.TransportWhoAmIAction;
import org.opensearch.performanceanalyzer.http_action.whoami.WhoAmIAction;
import org.opensearch.performanceanalyzer.listener.PerformanceAnalyzerSearchListener;
import org.opensearch.performanceanalyzer.transport.PerformanceAnalyzerTransportInterceptor;
import org.opensearch.performanceanalyzer.util.Utils;
import org.opensearch.performanceanalyzer.writer.EventLogQueueProcessor;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.NetworkPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.SearchPlugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.script.ScriptService;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.Transport;
import org.opensearch.transport.TransportInterceptor;
import org.opensearch.watcher.ResourceWatcherService;

public final class PerformanceAnalyzerPlugin
extends Plugin
implements ActionPlugin,
NetworkPlugin,
SearchPlugin {
    private static final Logger LOG = LogManager.getLogger(PerformanceAnalyzerPlugin.class);
    public static final String PLUGIN_NAME = "opensearch-performance-analyzer";
    private static final String ADD_FAULT_DETECTION_METHOD = "addFaultDetectionListener";
    private static final String LISTENER_INJECTOR_CLASS_PATH = "org.opensearch.performanceanalyzer.listener.ListenerInjector";
    public static final int QUEUE_PURGE_INTERVAL_MS = 1000;
    private static SecurityManager sm = null;
    private final PerformanceAnalyzerClusterSettingHandler perfAnalyzerClusterSettingHandler;
    private final NodeStatsSettingHandler nodeStatsSettingHandler;
    private final ConfigOverridesClusterSettingHandler configOverridesClusterSettingHandler;
    private final ConfigOverridesWrapper configOverridesWrapper;
    private final PerformanceAnalyzerController performanceAnalyzerController;
    private final ClusterSettingsManager clusterSettingsManager;
    private final ScheduledMetricCollectorsExecutor scheduledMetricCollectorsExecutor;

    public static void invokePrivileged(Runnable runner) {
        AccessController.doPrivileged(() -> {
            try {
                runner.run();
            }
            catch (Exception ex) {
                LOG.debug(() -> new ParameterizedMessage("Privileged Invocation failed {}", (Object)ex.toString()), (Throwable)ex);
            }
            return null;
        });
    }

    public PerformanceAnalyzerPlugin(Settings settings, Path configPath) {
        OSMetricsGeneratorFactory.getInstance();
        OpenSearchResources.INSTANCE.setSettings(settings);
        OpenSearchResources.INSTANCE.setConfigPath(configPath);
        OpenSearchResources.INSTANCE.setPluginFileLocation(new Environment(settings, configPath).pluginsFile().toAbsolutePath().toString() + File.separator + PLUGIN_NAME + File.separator);
        PluginSettings.instance();
        this.scheduledMetricCollectorsExecutor = new ScheduledMetricCollectorsExecutor();
        this.performanceAnalyzerController = new PerformanceAnalyzerController(this.scheduledMetricCollectorsExecutor);
        this.configOverridesWrapper = new ConfigOverridesWrapper();
        this.clusterSettingsManager = new ClusterSettingsManager(Arrays.asList(PerformanceAnalyzerClusterSettings.COMPOSITE_PA_SETTING, PerformanceAnalyzerClusterSettings.PA_NODE_STATS_SETTING), Collections.singletonList(PerformanceAnalyzerClusterSettings.CONFIG_OVERRIDES_SETTING));
        this.configOverridesClusterSettingHandler = new ConfigOverridesClusterSettingHandler(this.configOverridesWrapper, this.clusterSettingsManager, PerformanceAnalyzerClusterSettings.CONFIG_OVERRIDES_SETTING);
        this.clusterSettingsManager.addSubscriberForStringSetting(PerformanceAnalyzerClusterSettings.CONFIG_OVERRIDES_SETTING, this.configOverridesClusterSettingHandler);
        this.perfAnalyzerClusterSettingHandler = new PerformanceAnalyzerClusterSettingHandler(this.performanceAnalyzerController, this.clusterSettingsManager);
        this.clusterSettingsManager.addSubscriberForIntSetting(PerformanceAnalyzerClusterSettings.COMPOSITE_PA_SETTING, this.perfAnalyzerClusterSettingHandler);
        this.nodeStatsSettingHandler = new NodeStatsSettingHandler(this.performanceAnalyzerController, this.clusterSettingsManager);
        this.clusterSettingsManager.addSubscriberForIntSetting(PerformanceAnalyzerClusterSettings.PA_NODE_STATS_SETTING, this.nodeStatsSettingHandler);
        this.scheduledMetricCollectorsExecutor.addScheduledMetricCollector((PerformanceAnalyzerMetricsCollector)new ThreadPoolMetricsCollector());
        this.scheduledMetricCollectorsExecutor.addScheduledMetricCollector((PerformanceAnalyzerMetricsCollector)new CacheConfigMetricsCollector());
        this.scheduledMetricCollectorsExecutor.addScheduledMetricCollector((PerformanceAnalyzerMetricsCollector)new CircuitBreakerCollector());
        this.scheduledMetricCollectorsExecutor.addScheduledMetricCollector((PerformanceAnalyzerMetricsCollector)new OSMetricsCollector());
        this.scheduledMetricCollectorsExecutor.addScheduledMetricCollector((PerformanceAnalyzerMetricsCollector)new HeapMetricsCollector());
        this.scheduledMetricCollectorsExecutor.addScheduledMetricCollector((PerformanceAnalyzerMetricsCollector)new NodeDetailsCollector(this.configOverridesWrapper));
        this.scheduledMetricCollectorsExecutor.addScheduledMetricCollector((PerformanceAnalyzerMetricsCollector)new NodeStatsAllShardsMetricsCollector(this.performanceAnalyzerController));
        this.scheduledMetricCollectorsExecutor.addScheduledMetricCollector((PerformanceAnalyzerMetricsCollector)new ClusterManagerServiceMetrics());
        this.scheduledMetricCollectorsExecutor.addScheduledMetricCollector((PerformanceAnalyzerMetricsCollector)new ClusterManagerServiceEventMetrics());
        this.scheduledMetricCollectorsExecutor.addScheduledMetricCollector((PerformanceAnalyzerMetricsCollector)new DisksCollector());
        this.scheduledMetricCollectorsExecutor.addScheduledMetricCollector((PerformanceAnalyzerMetricsCollector)new NetworkInterfaceCollector());
        this.scheduledMetricCollectorsExecutor.addScheduledMetricCollector((PerformanceAnalyzerMetricsCollector)new GCInfoCollector());
        this.scheduledMetricCollectorsExecutor.addScheduledMetricCollector((PerformanceAnalyzerMetricsCollector)StatsCollector.instance());
        this.scheduledMetricCollectorsExecutor.addScheduledMetricCollector((PerformanceAnalyzerMetricsCollector)new FaultDetectionMetricsCollector(this.performanceAnalyzerController, this.configOverridesWrapper));
        this.scheduledMetricCollectorsExecutor.addScheduledMetricCollector((PerformanceAnalyzerMetricsCollector)new ShardStateCollector(this.performanceAnalyzerController, this.configOverridesWrapper));
        this.scheduledMetricCollectorsExecutor.addScheduledMetricCollector((PerformanceAnalyzerMetricsCollector)new ClusterManagerThrottlingMetricsCollector(this.performanceAnalyzerController, this.configOverridesWrapper));
        this.scheduledMetricCollectorsExecutor.addScheduledMetricCollector((PerformanceAnalyzerMetricsCollector)new ClusterApplierServiceStatsCollector(this.performanceAnalyzerController, this.configOverridesWrapper));
        this.scheduledMetricCollectorsExecutor.addScheduledMetricCollector((PerformanceAnalyzerMetricsCollector)new AdmissionControlMetricsCollector());
        this.scheduledMetricCollectorsExecutor.addScheduledMetricCollector((PerformanceAnalyzerMetricsCollector)new ElectionTermCollector(this.performanceAnalyzerController, this.configOverridesWrapper));
        try {
            Class.forName("org.opensearch.index.ShardIndexingPressure");
            this.scheduledMetricCollectorsExecutor.addScheduledMetricCollector((PerformanceAnalyzerMetricsCollector)new ShardIndexingPressureMetricsCollector(this.performanceAnalyzerController, this.configOverridesWrapper));
        }
        catch (ClassNotFoundException e) {
            LOG.info("Shard IndexingPressure not present in this OpenSearch version. Skipping ShardIndexingPressureMetricsCollector");
        }
        this.scheduledMetricCollectorsExecutor.start();
        EventLog eventLog = new EventLog();
        EventLogFileHandler eventLogFileHandler = new EventLogFileHandler(eventLog, PluginSettings.instance().getMetricsLocation());
        new EventLogQueueProcessor(eventLogFileHandler, 5000L, 1000L, this.performanceAnalyzerController).scheduleExecutor();
    }

    public List<ActionFilter> getActionFilters() {
        return Collections.singletonList(new PerformanceAnalyzerActionFilter(this.performanceAnalyzerController));
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> actions = new ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>>(1);
        actions.add(new ActionPlugin.ActionHandler((ActionType)WhoAmIAction.INSTANCE, TransportWhoAmIAction.class, new Class[0]));
        return actions;
    }

    public void onIndexModule(IndexModule indexModule) {
        PerformanceAnalyzerSearchListener performanceanalyzerSearchListener = new PerformanceAnalyzerSearchListener(this.performanceAnalyzerController);
        indexModule.addSearchOperationListener((SearchOperationListener)performanceanalyzerSearchListener);
    }

    public void onDiscovery(Discovery discovery) {
        try {
            Class<?> listenerInjector = Class.forName(LISTENER_INJECTOR_CLASS_PATH);
            Object listenerInjectorInstance = listenerInjector.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method addListenerMethod = listenerInjectorInstance.getClass().getMethod(ADD_FAULT_DETECTION_METHOD, Discovery.class);
            addListenerMethod.invoke(listenerInjectorInstance, discovery);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOG.debug("Exception while calling addFaultDetectionListener in Discovery");
        }
        catch (ClassNotFoundException e) {
            LOG.debug("No Class for ListenerInjector detected");
        }
    }

    public List<TransportInterceptor> getTransportInterceptors(NamedWriteableRegistry namedWriteableRegistry, ThreadContext threadContext) {
        return Collections.singletonList(new PerformanceAnalyzerTransportInterceptor(this.performanceAnalyzerController));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        PerformanceAnalyzerConfigAction performanceanalyzerConfigAction = new PerformanceAnalyzerConfigAction(restController, this.performanceAnalyzerController);
        PerformanceAnalyzerConfigAction.setInstance(performanceanalyzerConfigAction);
        PerformanceAnalyzerResourceProvider performanceAnalyzerRp = new PerformanceAnalyzerResourceProvider(settings, restController);
        PerformanceAnalyzerClusterConfigAction paClusterConfigAction = new PerformanceAnalyzerClusterConfigAction(settings, restController, this.perfAnalyzerClusterSettingHandler, this.nodeStatsSettingHandler);
        PerformanceAnalyzerOverridesClusterConfigAction paOverridesConfigClusterAction = new PerformanceAnalyzerOverridesClusterConfigAction(settings, restController, this.configOverridesClusterSettingHandler, this.configOverridesWrapper);
        return Arrays.asList(new RestHandler[]{performanceanalyzerConfigAction, paClusterConfigAction, performanceAnalyzerRp, paOverridesConfigClusterAction});
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        OpenSearchResources.INSTANCE.setClusterService(clusterService);
        OpenSearchResources.INSTANCE.setThreadPool(threadPool);
        OpenSearchResources.INSTANCE.setEnvironment(environment);
        OpenSearchResources.INSTANCE.setClient(client);
        this.clusterSettingsManager.initialize();
        return Collections.singletonList(this.performanceAnalyzerController);
    }

    public Map<String, Supplier<Transport>> getTransports(Settings settings, ThreadPool threadPool, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService, Tracer tracer) {
        OpenSearchResources.INSTANCE.setSettings(settings);
        OpenSearchResources.INSTANCE.setCircuitBreakerService(circuitBreakerService);
        return Collections.emptyMap();
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(PerformanceAnalyzerClusterSettings.COMPOSITE_PA_SETTING, PerformanceAnalyzerClusterSettings.PA_NODE_STATS_SETTING, PerformanceAnalyzerClusterSettings.CONFIG_OVERRIDES_SETTING);
    }

    static {
        SecurityManager sm = System.getSecurityManager();
        Utils.configureMetrics();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
    }
}

