/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.ml;

import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import java.util.concurrent.ConcurrentHashMap;
import org.opensearch.ad.MemoryTracker;
import org.opensearch.ad.ml.ModelState;

public class TRCFMemoryAwareConcurrentHashmap<K>
extends ConcurrentHashMap<K, ModelState<ThresholdedRandomCutForest>> {
    private final MemoryTracker memoryTracker;

    public TRCFMemoryAwareConcurrentHashmap(MemoryTracker memoryTracker) {
        this.memoryTracker = memoryTracker;
    }

    @Override
    public ModelState<ThresholdedRandomCutForest> remove(Object key) {
        ModelState deletedModelState = (ModelState)super.remove(key);
        if (deletedModelState != null && deletedModelState.getModel() != null) {
            long memoryToRelease = this.memoryTracker.estimateTRCFModelSize((ThresholdedRandomCutForest)deletedModelState.getModel());
            this.memoryTracker.releaseMemory(memoryToRelease, true, MemoryTracker.Origin.SINGLE_ENTITY_DETECTOR);
        }
        return deletedModelState;
    }

    @Override
    public ModelState<ThresholdedRandomCutForest> put(K key, ModelState<ThresholdedRandomCutForest> value) {
        ModelState<ThresholdedRandomCutForest> previousAssociatedState = super.put(key, value);
        if (value != null && value.getModel() != null) {
            long memoryToConsume = this.memoryTracker.estimateTRCFModelSize(value.getModel());
            this.memoryTracker.consumeMemory(memoryToConsume, true, MemoryTracker.Origin.SINGLE_ENTITY_DETECTOR);
        }
        return previousAssociatedState;
    }
}

