/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.painless.ir;

import java.util.ArrayList;
import org.opensearch.painless.ClassWriter;
import org.opensearch.painless.Location;
import org.opensearch.painless.MethodWriter;
import org.opensearch.painless.ir.ArgumentsNode;
import org.opensearch.painless.ir.DefInterfaceReferenceNode;
import org.opensearch.painless.ir.ExpressionNode;
import org.opensearch.painless.phase.IRTreeVisitor;
import org.opensearch.painless.symbol.WriteScope;
import org.opensearch.repackage.org.objectweb.asm.Type;

public class InvokeCallDefNode
extends ArgumentsNode {
    private String name;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitInvokeCallDef(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        for (ExpressionNode argumentNode : this.getArgumentNodes()) {
            argumentNode.visit(irTreeVisitor, scope);
        }
    }

    public InvokeCallDefNode(Location location) {
        super(location);
    }

    @Override
    protected void write(ClassWriter classWriter, MethodWriter methodWriter, WriteScope writeScope) {
        methodWriter.writeDebugInfo(this.getLocation());
        StringBuilder defCallRecipe = new StringBuilder();
        ArrayList<String> boostrapArguments = new ArrayList<String>();
        ArrayList typeParameters = new ArrayList();
        int capturedCount = 0;
        typeParameters.add(Object.class);
        for (int i = 0; i < this.getArgumentNodes().size(); ++i) {
            ExpressionNode argumentNode = this.getArgumentNodes().get(i);
            argumentNode.write(classWriter, methodWriter, writeScope);
            typeParameters.add(argumentNode.getExpressionType());
            if (!(argumentNode instanceof DefInterfaceReferenceNode)) continue;
            DefInterfaceReferenceNode defInterfaceReferenceNode = (DefInterfaceReferenceNode)argumentNode;
            boostrapArguments.add(defInterfaceReferenceNode.getDefReferenceEncoding());
            char encoding = (char)(i + capturedCount);
            defCallRecipe.append(encoding);
            capturedCount += defInterfaceReferenceNode.getCaptures().size();
            for (String capturedName : defInterfaceReferenceNode.getCaptures()) {
                WriteScope.Variable capturedVariable = writeScope.getVariable(capturedName);
                typeParameters.add(capturedVariable.getType());
            }
        }
        Type[] asmParameterTypes = new Type[typeParameters.size()];
        for (int index = 0; index < asmParameterTypes.length; ++index) {
            asmParameterTypes[index] = MethodWriter.getType((Class)typeParameters.get(index));
        }
        Type methodType = Type.getMethodType(MethodWriter.getType(this.getExpressionType()), asmParameterTypes);
        boostrapArguments.add(0, defCallRecipe.toString());
        methodWriter.invokeDefCall(this.name, methodType, 0, boostrapArguments.toArray());
    }
}

