/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.telemetry.tracing;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.opensearch.common.annotation.InternalApi;
import org.opensearch.telemetry.TelemetrySettings;
import org.opensearch.telemetry.tracing.ScopedSpan;
import org.opensearch.telemetry.tracing.Span;
import org.opensearch.telemetry.tracing.SpanContext;
import org.opensearch.telemetry.tracing.SpanCreationContext;
import org.opensearch.telemetry.tracing.SpanScope;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.telemetry.tracing.noop.NoopTracer;

@InternalApi
final class WrappedTracer
implements Tracer {
    private final Tracer defaultTracer;
    private final TelemetrySettings telemetrySettings;

    public WrappedTracer(TelemetrySettings telemetrySettings, Tracer defaultTracer) {
        this.defaultTracer = defaultTracer;
        this.telemetrySettings = telemetrySettings;
    }

    public Span startSpan(SpanCreationContext context) {
        return this.getDelegateTracer().startSpan(context);
    }

    public SpanContext getCurrentSpan() {
        Tracer delegateTracer = this.getDelegateTracer();
        return delegateTracer.getCurrentSpan();
    }

    public ScopedSpan startScopedSpan(SpanCreationContext spanCreationContext) {
        return this.getDelegateTracer().startScopedSpan(spanCreationContext);
    }

    public SpanScope withSpanInScope(Span span) {
        return this.getDelegateTracer().withSpanInScope(span);
    }

    public void close() throws IOException {
        this.defaultTracer.close();
    }

    Tracer getDelegateTracer() {
        return this.telemetrySettings.isTracingEnabled() ? this.defaultTracer : NoopTracer.INSTANCE;
    }

    public Span startSpan(SpanCreationContext spanCreationContext, Map<String, List<String>> headers) {
        return this.defaultTracer.startSpan(spanCreationContext, headers);
    }
}

