/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.monitor.fs;

import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.Constants;
import org.opensearch.common.SuppressForbidden;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.io.PathUtils;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.index.store.remote.filecache.FileCache;
import org.opensearch.monitor.fs.FsInfo;

public class FsProbe {
    private static final Logger logger = LogManager.getLogger(FsProbe.class);
    private final NodeEnvironment nodeEnv;
    private final FileCache fileCache;

    public FsProbe(NodeEnvironment nodeEnv, FileCache fileCache) {
        this.nodeEnv = nodeEnv;
        this.fileCache = fileCache;
    }

    public FsInfo stats(FsInfo previous) throws IOException {
        if (!this.nodeEnv.hasNodeFile()) {
            return new FsInfo(System.currentTimeMillis(), null, new FsInfo.Path[0]);
        }
        NodeEnvironment.NodePath[] dataLocations = this.nodeEnv.nodePaths();
        FsInfo.Path[] paths = new FsInfo.Path[dataLocations.length];
        for (int i = 0; i < dataLocations.length; ++i) {
            paths[i] = FsProbe.getFSInfo(dataLocations[i]);
            if (this.fileCache == null || dataLocations[i].fileCacheReservedSize == ByteSizeValue.ZERO) continue;
            paths[i].fileCacheReserved = FsProbe.adjustForHugeFilesystems(dataLocations[i].fileCacheReservedSize.getBytes());
            paths[i].fileCacheUtilized = FsProbe.adjustForHugeFilesystems(this.fileCache.usage().usage());
            paths[i].available -= paths[i].fileCacheReserved - paths[i].fileCacheUtilized;
        }
        FsInfo.IoStats ioStats = null;
        if (Constants.LINUX) {
            HashSet<Tuple<Integer, Integer>> devicesNumbers = new HashSet<Tuple<Integer, Integer>>();
            for (NodeEnvironment.NodePath dataLocation : dataLocations) {
                if (dataLocation.majorDeviceNumber == -1 || dataLocation.minorDeviceNumber == -1) continue;
                devicesNumbers.add((Tuple<Integer, Integer>)Tuple.tuple((Object)dataLocation.majorDeviceNumber, (Object)dataLocation.minorDeviceNumber));
            }
            ioStats = this.ioStats(devicesNumbers, previous);
        }
        return new FsInfo(System.currentTimeMillis(), ioStats, paths);
    }

    final FsInfo.IoStats ioStats(Set<Tuple<Integer, Integer>> devicesNumbers, FsInfo previous) {
        try {
            HashMap<Tuple, FsInfo.DeviceStats> deviceMap = new HashMap<Tuple, FsInfo.DeviceStats>();
            if (previous != null && previous.getIoStats() != null && previous.getIoStats().devicesStats != null) {
                for (int i = 0; i < previous.getIoStats().devicesStats.length; ++i) {
                    FsInfo.DeviceStats deviceStats = previous.getIoStats().devicesStats[i];
                    deviceMap.put(Tuple.tuple((Object)deviceStats.majorDeviceNumber, (Object)deviceStats.minorDeviceNumber), deviceStats);
                }
            }
            ArrayList<FsInfo.DeviceStats> devicesStats = new ArrayList<FsInfo.DeviceStats>();
            List<String> lines = this.readProcDiskStats();
            if (!lines.isEmpty()) {
                for (String line : lines) {
                    String[] fields = line.trim().split("\\s+");
                    int majorDeviceNumber = Integer.parseInt(fields[0]);
                    int minorDeviceNumber = Integer.parseInt(fields[1]);
                    if (!devicesNumbers.contains(Tuple.tuple((Object)majorDeviceNumber, (Object)minorDeviceNumber))) continue;
                    String deviceName = fields[2];
                    long readsCompleted = Long.parseLong(fields[3]);
                    long sectorsRead = Long.parseLong(fields[5]);
                    long writesCompleted = Long.parseLong(fields[7]);
                    long sectorsWritten = Long.parseLong(fields[9]);
                    FsInfo.DeviceStats deviceStats = new FsInfo.DeviceStats(majorDeviceNumber, minorDeviceNumber, deviceName, readsCompleted, sectorsRead, writesCompleted, sectorsWritten, (FsInfo.DeviceStats)deviceMap.get(Tuple.tuple((Object)majorDeviceNumber, (Object)minorDeviceNumber)));
                    devicesStats.add(deviceStats);
                }
            }
            return new FsInfo.IoStats(devicesStats.toArray(new FsInfo.DeviceStats[devicesStats.size()]));
        }
        catch (Exception e) {
            logger.debug(() -> new ParameterizedMessage("unexpected exception processing /proc/diskstats for devices {}", (Object)devicesNumbers), (Throwable)e);
            return null;
        }
    }

    @SuppressForbidden(reason="read /proc/diskstats")
    List<String> readProcDiskStats() throws IOException {
        return Files.readAllLines(PathUtils.get((String)"/proc/diskstats", (String[])new String[0]));
    }

    static long adjustForHugeFilesystems(long bytes) {
        if (bytes < 0L) {
            return Long.MAX_VALUE;
        }
        return bytes;
    }

    public static FsInfo.Path getFSInfo(NodeEnvironment.NodePath nodePath) throws IOException {
        FsInfo.Path fsPath = new FsInfo.Path();
        fsPath.path = nodePath.path.toString();
        fsPath.total = FsProbe.adjustForHugeFilesystems(nodePath.fileStore.getTotalSpace());
        fsPath.free = FsProbe.adjustForHugeFilesystems(nodePath.fileStore.getUnallocatedSpace());
        fsPath.available = FsProbe.adjustForHugeFilesystems(nodePath.fileStore.getUsableSpace());
        fsPath.fileCacheReserved = FsProbe.adjustForHugeFilesystems(nodePath.fileCacheReservedSize.getBytes());
        fsPath.type = nodePath.fileStore.type();
        fsPath.mount = nodePath.fileStore.toString();
        return fsPath;
    }
}

