/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geo.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.DoubleArray;
import org.opensearch.geo.search.aggregations.metrics.InternalGeoBounds;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.metrics.MetricsAggregator;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.internal.SearchContext;

public abstract class AbstractGeoBoundsAggregator<T extends ValuesSource>
extends MetricsAggregator {
    protected final T valuesSource;
    protected final boolean wrapLongitude;
    protected DoubleArray tops;
    protected DoubleArray bottoms;
    protected DoubleArray posLefts;
    protected DoubleArray posRights;
    protected DoubleArray negLefts;
    protected DoubleArray negRights;

    protected AbstractGeoBoundsAggregator(String name, SearchContext searchContext, Aggregator aggregator, ValuesSourceConfig valuesSourceConfig, boolean wrapLongitude, Map<String, Object> metaData) throws IOException {
        super(name, searchContext, aggregator, metaData);
        this.wrapLongitude = wrapLongitude;
        Object object = this.valuesSource = valuesSourceConfig.hasValues() ? valuesSourceConfig.getValuesSource() : null;
        if (this.valuesSource != null) {
            BigArrays bigArrays = this.context.bigArrays();
            this.tops = bigArrays.newDoubleArray(1L, false);
            this.tops.fill(0L, this.tops.size(), Double.NEGATIVE_INFINITY);
            this.bottoms = bigArrays.newDoubleArray(1L, false);
            this.bottoms.fill(0L, this.bottoms.size(), Double.POSITIVE_INFINITY);
            this.posLefts = bigArrays.newDoubleArray(1L, false);
            this.posLefts.fill(0L, this.posLefts.size(), Double.POSITIVE_INFINITY);
            this.posRights = bigArrays.newDoubleArray(1L, false);
            this.posRights.fill(0L, this.posRights.size(), Double.NEGATIVE_INFINITY);
            this.negLefts = bigArrays.newDoubleArray(1L, false);
            this.negLefts.fill(0L, this.negLefts.size(), Double.POSITIVE_INFINITY);
            this.negRights = bigArrays.newDoubleArray(1L, false);
            this.negRights.fill(0L, this.negRights.size(), Double.NEGATIVE_INFINITY);
        }
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalGeoBounds(this.name, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, this.wrapLongitude, this.metadata());
    }

    public InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        if (this.valuesSource == null) {
            return this.buildEmptyAggregation();
        }
        double top = this.tops.get(owningBucketOrdinal);
        double bottom = this.bottoms.get(owningBucketOrdinal);
        double posLeft = this.posLefts.get(owningBucketOrdinal);
        double posRight = this.posRights.get(owningBucketOrdinal);
        double negLeft = this.negLefts.get(owningBucketOrdinal);
        double negRight = this.negRights.get(owningBucketOrdinal);
        return new InternalGeoBounds(this.name, top, bottom, posLeft, posRight, negLeft, negRight, this.wrapLongitude, this.metadata());
    }

    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.tops, this.bottoms, this.posLefts, this.posRights, this.negLefts, this.negRights});
    }

    protected void setBucketSize(long bucket, BigArrays bigArrays) {
        if (bucket >= this.tops.size()) {
            long from = this.tops.size();
            this.tops = bigArrays.grow(this.tops, bucket + 1L);
            this.tops.fill(from, this.tops.size(), Double.NEGATIVE_INFINITY);
            this.bottoms = bigArrays.resize(this.bottoms, this.tops.size());
            this.bottoms.fill(from, this.bottoms.size(), Double.POSITIVE_INFINITY);
            this.posLefts = bigArrays.resize(this.posLefts, this.tops.size());
            this.posLefts.fill(from, this.posLefts.size(), Double.POSITIVE_INFINITY);
            this.posRights = bigArrays.resize(this.posRights, this.tops.size());
            this.posRights.fill(from, this.posRights.size(), Double.NEGATIVE_INFINITY);
            this.negLefts = bigArrays.resize(this.negLefts, this.tops.size());
            this.negLefts.fill(from, this.negLefts.size(), Double.POSITIVE_INFINITY);
            this.negRights = bigArrays.resize(this.negRights, this.tops.size());
            this.negRights.fill(from, this.negRights.size(), Double.NEGATIVE_INFINITY);
        }
    }
}

