/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.osmand.osm.MapPoiTypes;
import net.osmand.osm.PoiFilter;
import net.osmand.osm.PoiType;

public class PoiCategory
extends PoiFilter {
    private List<PoiFilter> poiFilters = new ArrayList<PoiFilter>();
    private Set<PoiType> basemapPoi = null;
    private int regId;
    private String defaultTag;

    public PoiCategory(MapPoiTypes registry, String keyName, int regId) {
        super(registry, null, keyName);
        this.regId = regId;
    }

    public void addPoiType(PoiFilter poi) {
        this.poiFilters.add(poi);
    }

    public List<PoiFilter> getPoiFilters() {
        return this.poiFilters;
    }

    public String getDefaultTag() {
        if (this.defaultTag == null) {
            return this.keyName;
        }
        return this.defaultTag;
    }

    public void setDefaultTag(String defaultTag) {
        this.defaultTag = defaultTag;
    }

    @Override
    public Map<PoiCategory, LinkedHashSet<String>> putTypes(Map<PoiCategory, LinkedHashSet<String>> acceptedTypes) {
        acceptedTypes.put(this, null);
        this.addReferenceTypes(acceptedTypes);
        return acceptedTypes;
    }

    public boolean isWiki() {
        return this.keyName.equals("osmwiki");
    }

    public int ordinal() {
        return this.regId;
    }

    public void addBasemapPoi(PoiType pt) {
        if (this.basemapPoi == null) {
            this.basemapPoi = new HashSet<PoiType>();
        }
        this.basemapPoi.add(pt);
    }

    public boolean containsBasemapPoi(PoiType pt) {
        if (this.basemapPoi == null) {
            return false;
        }
        return this.basemapPoi.contains(pt);
    }
}

