# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.4.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from peertube.configuration import Configuration


class RegisterUser(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'username': 'str',
        'password': 'str',
        'email': 'str',
        'display_name': 'str',
        'channel': 'RegisterUserChannel'
    }

    attribute_map = {
        'username': 'username',
        'password': 'password',
        'email': 'email',
        'display_name': 'displayName',
        'channel': 'channel'
    }

    def __init__(self, username=None, password=None, email=None, display_name=None, channel=None, local_vars_configuration=None):  # noqa: E501
        """RegisterUser - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._username = None
        self._password = None
        self._email = None
        self._display_name = None
        self._channel = None
        self.discriminator = None

        self.username = username
        self.password = password
        self.email = email
        if display_name is not None:
            self.display_name = display_name
        if channel is not None:
            self.channel = channel

    @property
    def username(self):
        """Gets the username of this RegisterUser.  # noqa: E501

        The username of the user  # noqa: E501

        :return: The username of this RegisterUser.  # noqa: E501
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """Sets the username of this RegisterUser.

        The username of the user  # noqa: E501

        :param username: The username of this RegisterUser.  # noqa: E501
        :type username: str
        """
        if self.local_vars_configuration.client_side_validation and username is None:  # noqa: E501
            raise ValueError("Invalid value for `username`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                username is not None and len(username) > 50):
            raise ValueError("Invalid value for `username`, length must be less than or equal to `50`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                username is not None and len(username) < 1):
            raise ValueError("Invalid value for `username`, length must be greater than or equal to `1`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                username is not None and not re.search(r'^[a-z0-9._]{1,50}$', username)):  # noqa: E501
            raise ValueError(r"Invalid value for `username`, must be a follow pattern or equal to `/^[a-z0-9._]{1,50}$/`")  # noqa: E501

        self._username = username

    @property
    def password(self):
        """Gets the password of this RegisterUser.  # noqa: E501

        The password of the user  # noqa: E501

        :return: The password of this RegisterUser.  # noqa: E501
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """Sets the password of this RegisterUser.

        The password of the user  # noqa: E501

        :param password: The password of this RegisterUser.  # noqa: E501
        :type password: str
        """
        if self.local_vars_configuration.client_side_validation and password is None:  # noqa: E501
            raise ValueError("Invalid value for `password`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                password is not None and len(password) > 255):
            raise ValueError("Invalid value for `password`, length must be less than or equal to `255`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                password is not None and len(password) < 6):
            raise ValueError("Invalid value for `password`, length must be greater than or equal to `6`")  # noqa: E501

        self._password = password

    @property
    def email(self):
        """Gets the email of this RegisterUser.  # noqa: E501

        The email of the user  # noqa: E501

        :return: The email of this RegisterUser.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this RegisterUser.

        The email of the user  # noqa: E501

        :param email: The email of this RegisterUser.  # noqa: E501
        :type email: str
        """
        if self.local_vars_configuration.client_side_validation and email is None:  # noqa: E501
            raise ValueError("Invalid value for `email`, must not be `None`")  # noqa: E501

        self._email = email

    @property
    def display_name(self):
        """Gets the display_name of this RegisterUser.  # noqa: E501

        The user display name  # noqa: E501

        :return: The display_name of this RegisterUser.  # noqa: E501
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """Sets the display_name of this RegisterUser.

        The user display name  # noqa: E501

        :param display_name: The display_name of this RegisterUser.  # noqa: E501
        :type display_name: str
        """
        if (self.local_vars_configuration.client_side_validation and
                display_name is not None and len(display_name) > 120):
            raise ValueError("Invalid value for `display_name`, length must be less than or equal to `120`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                display_name is not None and len(display_name) < 1):
            raise ValueError("Invalid value for `display_name`, length must be greater than or equal to `1`")  # noqa: E501

        self._display_name = display_name

    @property
    def channel(self):
        """Gets the channel of this RegisterUser.  # noqa: E501


        :return: The channel of this RegisterUser.  # noqa: E501
        :rtype: RegisterUserChannel
        """
        return self._channel

    @channel.setter
    def channel(self, channel):
        """Sets the channel of this RegisterUser.


        :param channel: The channel of this RegisterUser.  # noqa: E501
        :type channel: RegisterUserChannel
        """

        self._channel = channel

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RegisterUser):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RegisterUser):
            return True

        return self.to_dict() != other.to_dict()
