/*
 * Decompiled with CFR 0.152.
 */
package de.danielnaber.jwordsplitter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GermanInterfixDisambiguator {
    private static final Set<String> wordsRequiringInterfixS = new HashSet<String>();
    private final Set<String> dictionary;

    GermanInterfixDisambiguator(Set<String> dictionary) {
        this.dictionary = dictionary;
    }

    List<String> disambiguate(List<String> parts) {
        String lastPart;
        ArrayList<String> newParts = new ArrayList<String>(parts);
        int lastPartIdx = parts.size() - 1;
        if (parts.size() > 1 && ((lastPart = parts.get(lastPartIdx)).equals("samt") || lastPart.equals("samts") || lastPart.equals("samtes"))) {
            newParts.set(lastPartIdx - 1, parts.get(lastPartIdx - 1) + "s");
            newParts.set(lastPartIdx, lastPart.replaceFirst("^s", ""));
            return newParts;
        }
        for (int i = newParts.size() - 1; i >= 2; --i) {
            boolean partIsWord;
            String part = (String)newParts.get(i);
            String prevPart = (String)newParts.get(i - 1);
            String prevPrevPart = (String)newParts.get(i - 2);
            if (!prevPart.equals("s") || (partIsWord = this.isWord("s" + part)) && !wordsRequiringInterfixS.contains(prevPrevPart)) continue;
            newParts.set(i - 2, prevPrevPart + "s");
            newParts.remove(i - 1);
        }
        return newParts;
    }

    private boolean isWord(String word) {
        return this.dictionary.contains(word.toLowerCase());
    }

    static {
        wordsRequiringInterfixS.add("Verhalten");
    }
}

