/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.data.gpx.GpxConstants;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.io.GpxParser;
import org.openstreetmap.josm.io.IGpxReader;
import org.openstreetmap.josm.io.InvalidXmlCharacterFilter;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.XmlUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class GpxReader
implements GpxConstants,
IGpxReader {
    private GpxData gpxData;
    private final InputSource inputSource;

    public GpxReader(InputStream source) throws IOException {
        UTFInputStreamReader utf8stream = UTFInputStreamReader.create(source);
        InvalidXmlCharacterFilter filtered = new InvalidXmlCharacterFilter(utf8stream);
        this.inputSource = new InputSource(filtered);
    }

    @Override
    public boolean parse(boolean tryToFinish) throws SAXException, IOException {
        GpxParser parser = new GpxParser();
        try {
            XmlUtils.parseSafeSAX(this.inputSource, parser);
            boolean bl = true;
            return bl;
        }
        catch (SAXException e) {
            if (tryToFinish) {
                parser.tryToFinish();
                String message = e.getLocalizedMessage();
                if (e instanceof SAXParseException) {
                    boolean dot;
                    boolean bl = dot = message.lastIndexOf(46) == message.length() - 1;
                    if (dot) {
                        message = message.substring(0, message.length() - 1);
                    }
                    SAXParseException spe = (SAXParseException)e;
                    message = message + ' ' + I18n.tr("(at line {0}, column {1})", spe.getLineNumber(), spe.getColumnNumber());
                    if (dot) {
                        message = message + '.';
                    }
                }
                if (!Utils.isBlank(parser.getData().creator)) {
                    message = message + "\n" + I18n.tr("The file was created by \"{0}\".", parser.getData().creator);
                }
                SAXException ex = new SAXException(message, e);
                if (parser.getData().isEmpty()) {
                    throw ex;
                }
                Logging.warn(ex);
                boolean bl = false;
                return bl;
            }
            throw e;
        }
        catch (ParserConfigurationException e) {
            Logging.error(e);
            throw new SAXException(e);
        }
        finally {
            if (parser.getData() != null) {
                this.gpxData = parser.getData();
            }
        }
    }

    @Override
    public GpxData getGpxData() {
        return this.gpxData;
    }
}

