/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.gradle.jvm.toolchain.internal.InstallationSupplier;

public class LocationListInstallationSupplier
implements InstallationSupplier {
    private static final String JAVA_INSTALLATIONS_PATHS_PROPERTY = "org.gradle.java.installations.paths";
    private final ProviderFactory factory;
    private final FileResolver fileResolver;

    @Inject
    public LocationListInstallationSupplier(ProviderFactory factory, FileResolver fileResolver) {
        this.factory = factory;
        this.fileResolver = fileResolver;
    }

    @Override
    public Set<InstallationLocation> get() {
        Provider property = this.factory.gradleProperty(JAVA_INSTALLATIONS_PATHS_PROPERTY);
        return (Set)property.map(paths -> this.asInstallations((String)paths)).orElse(Collections.emptySet()).get();
    }

    private Set<InstallationLocation> asInstallations(String listOfDirectories) {
        return Arrays.stream(listOfDirectories.split(",")).filter(path -> !path.trim().isEmpty()).map(path -> new InstallationLocation(this.fileResolver.resolve(path), "system property 'org.gradle.java.installations.paths'")).collect(Collectors.toSet());
    }
}

