/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirArrayOfCall;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirNamedVarargChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCallChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirNamedVarargChecker
extends FirExpressionChecker<FirCall> {
    @NotNull
    public static final FirNamedVarargChecker INSTANCE = new FirNamedVarargChecker();

    private FirNamedVarargChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirCall expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(expression2 instanceof FirFunctionCall || expression2 instanceof FirAnnotation || expression2 instanceof FirDelegatedConstructorCall || expression2 instanceof FirArrayOfCall)) {
            return;
        }
        boolean isAnnotation = expression2 instanceof FirAnnotation;
        KtDiagnosticFactory0 redundantSpreadWarningFactory = isAnnotation ? FirErrors.INSTANCE.getREDUNDANT_SPREAD_OPERATOR_IN_NAMED_FORM_IN_ANNOTATION() : FirErrors.INSTANCE.getREDUNDANT_SPREAD_OPERATOR_IN_NAMED_FORM_IN_FUNCTION();
        boolean allowAssignArray = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context.getSession()).supportsFeature(isAnnotation ? LanguageFeature.AssigningArraysToVarargsInNamedFormInAnnotations : LanguageFeature.AllowAssigningArrayElementsToVarargsInNamedFormForFunctions);
        if (expression2 instanceof FirArrayOfCall) {
            void $this$forEach$iv;
            Object $this$arguments$iv = expression2;
            boolean $i$f$getArguments = false;
            $this$arguments$iv = $this$arguments$iv.getArgumentList().getArguments();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirExpression it = (FirExpression)element$iv;
                boolean bl = false;
                FirNamedVarargChecker.check$checkArgument(expression2, reporter, redundantSpreadWarningFactory, context, allowAssignArray, isAnnotation, it, it instanceof FirNamedArgumentExpression, null);
            }
        } else {
            FirCall $this$argumentMapping$iv = expression2;
            boolean $i$f$getArgumentMapping = false;
            FirArgumentList argumentList$iv = $this$argumentMapping$iv.getArgumentList();
            LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
            if (linkedHashMap == null) {
                return;
            }
            LinkedHashMap<FirExpression, FirValueParameter> argumentMap = linkedHashMap;
            for (Map.Entry entry : ((Map)argumentMap).entrySet()) {
                FirExpression argument2 = (FirExpression)entry.getKey();
                FirValueParameter parameter = (FirValueParameter)entry.getValue();
                if (!parameter.isVararg()) continue;
                if (argument2 instanceof FirVarargArgumentsExpression) {
                    Iterable $this$forEach$iv = ((FirVarargArgumentsExpression)argument2).getArguments();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        FirExpression it = (FirExpression)element$iv;
                        boolean bl = false;
                        FirNamedVarargChecker.check$checkArgument(expression2, reporter, redundantSpreadWarningFactory, context, allowAssignArray, isAnnotation, it, true, FirTypeUtilsKt.getConeType(parameter.getReturnTypeRef()));
                    }
                    continue;
                }
                FirNamedVarargChecker.check$checkArgument(expression2, reporter, redundantSpreadWarningFactory, context, allowAssignArray, isAnnotation, argument2, false, FirTypeUtilsKt.getConeType(parameter.getReturnTypeRef()));
            }
        }
    }

    private static final void check$checkArgument(FirCall $expression, DiagnosticReporter $reporter, KtDiagnosticFactory0 redundantSpreadWarningFactory, CheckerContext $context, boolean allowAssignArray, boolean isAnnotation, FirExpression argument2, boolean isVararg, ConeKotlinType expectedArrayType) {
        if (!(argument2 instanceof FirNamedArgumentExpression)) {
            return;
        }
        if (((FirNamedArgumentExpression)argument2).isSpread()) {
            if (isVararg) {
                FirResolvable firResolvable = $expression instanceof FirResolvable ? (FirResolvable)((Object)$expression) : null;
                if (!((firResolvable != null ? firResolvable.getCalleeReference() : null) instanceof FirErrorNamedReference)) {
                    KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)((FirNamedArgumentExpression)argument2).getExpression().getSource(), redundantSpreadWarningFactory, (DiagnosticContext)$context, null, 8, null);
                }
            }
            return;
        }
        FirTypeRef typeRef = ((FirNamedArgumentExpression)argument2).getExpression().getTypeRef();
        if (typeRef instanceof FirErrorTypeRef) {
            return;
        }
        if (((FirNamedArgumentExpression)argument2).getExpression() instanceof FirArrayOfCall) {
            return;
        }
        if (allowAssignArray && FirTypeUtilsKt.isArrayType(typeRef)) {
            return;
        }
        if (isAnnotation) {
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)((FirNamedArgumentExpression)argument2).getExpression().getSource(), FirErrors.INSTANCE.getASSIGNING_SINGLE_ELEMENT_TO_VARARG_IN_NAMED_FORM_ANNOTATION(), (DiagnosticContext)$context, null, 8, null);
        } else {
            if (!(expectedArrayType != null)) {
                boolean bl = false;
                String string2 = "expectedArrayType must be passed for function call";
                throw new IllegalArgumentException(string2.toString());
            }
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)((FirNamedArgumentExpression)argument2).getExpression().getSource(), FirErrors.INSTANCE.getASSIGNING_SINGLE_ELEMENT_TO_VARARG_IN_NAMED_FORM_FUNCTION(), (Object)expectedArrayType, (DiagnosticContext)$context, null, 16, null);
        }
    }
}

