/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.api.types;

import org.gephi.graph.api.Estimator;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.types.IntervalMap;

public final class IntervalBooleanMap
extends IntervalMap<Boolean> {
    private boolean[] values;

    public IntervalBooleanMap() {
        this.values = new boolean[0];
    }

    public IntervalBooleanMap(int capacity) {
        super(capacity);
        this.values = new boolean[capacity];
    }

    public IntervalBooleanMap(double[] keys, boolean[] vals) {
        super(keys);
        this.values = new boolean[vals.length];
        System.arraycopy(vals, 0, this.values, 0, vals.length);
    }

    public boolean getBoolean(Interval interval) {
        int index = this.getIndex(interval.getLow(), interval.getHigh());
        if (index >= 0) {
            return this.values[index / 2];
        }
        throw new IllegalArgumentException("The element doesn't exist");
    }

    public boolean getBoolean(Interval interval, boolean defaultValue) {
        int index = this.getIndex(interval.getLow(), interval.getHigh());
        if (index >= 0) {
            return this.values[index / 2];
        }
        return defaultValue;
    }

    public boolean[] toBooleanArray() {
        return (boolean[])this.toNativeArray();
    }

    @Override
    public Class<Boolean> getTypeClass() {
        return Boolean.class;
    }

    @Override
    public boolean isSupported(Estimator estimator) {
        return estimator.is(Estimator.FIRST, Estimator.LAST, Estimator.MIN, Estimator.MAX);
    }

    @Override
    protected Object getMin(Interval interval) {
        if (this.size == 0) {
            return null;
        }
        int[] intervals = this.getOverlappingIntervals(interval.getLow(), interval.getHigh());
        if (intervals.length == 0) {
            return null;
        }
        for (int i = 0; i < intervals.length; ++i) {
            if (!this.getValue(intervals[i]).equals(Boolean.FALSE)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    protected Object getMax(Interval interval) {
        if (this.size == 0) {
            return null;
        }
        int[] intervals = this.getOverlappingIntervals(interval.getLow(), interval.getHigh());
        if (intervals.length == 0) {
            return null;
        }
        for (int i = 0; i < intervals.length; ++i) {
            if (!this.getValue(intervals[i]).equals(Boolean.TRUE)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    protected Boolean getValue(int index) {
        return this.values[index];
    }

    @Override
    protected Object getValuesArray() {
        return this.values;
    }

    @Override
    protected void setValuesArray(Object array) {
        this.values = (boolean[])array;
    }
}

