/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.graph;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.jgrapht.alg.cycle.CycleDetector;
import org.jgrapht.alg.cycle.JohnsonSimpleCycles;
import org.jgrapht.graph.AsSubgraph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.jgrapht.traverse.TopologicalOrderIterator;

public class GraphNodeSort<V> {
    private final Graph<V, DefaultWeightedEdge> graph = new SimpleDirectedWeightedGraph(DefaultWeightedEdge.class);

    public void addEdge(V source, V target, double weight) {
        this.graph.addVertex(source);
        this.graph.addVertex(target);
        DefaultWeightedEdge forwardEdge = (DefaultWeightedEdge)this.graph.getEdge(source, target);
        DefaultWeightedEdge reverseEdge = (DefaultWeightedEdge)this.graph.getEdge(target, source);
        if (reverseEdge != null) {
            double reverseWeight = this.graph.getEdgeWeight((Object)reverseEdge);
            if (weight > reverseWeight) {
                this.graph.removeEdge((Object)reverseEdge);
                DefaultWeightedEdge newEdge = (DefaultWeightedEdge)this.graph.addEdge(source, target);
                this.graph.setEdgeWeight((Object)newEdge, weight - reverseWeight);
            } else if (weight < reverseWeight) {
                this.graph.setEdgeWeight((Object)reverseEdge, reverseWeight - weight);
            } else {
                this.graph.removeEdge((Object)reverseEdge);
            }
        } else if (forwardEdge != null) {
            double currentWeight = this.graph.getEdgeWeight((Object)forwardEdge);
            this.graph.setEdgeWeight((Object)forwardEdge, currentWeight + weight);
        } else {
            DefaultWeightedEdge newEdge = (DefaultWeightedEdge)this.graph.addEdge(source, target);
            this.graph.setEdgeWeight((Object)newEdge, weight);
        }
    }

    public void addNode(V node) {
        this.graph.addVertex(node);
    }

    public List<List<V>> sortNodes(Comparator<Set<V>> secondComparator) {
        ConnectivityInspector connectivityInspector = new ConnectivityInspector(this.graph);
        List connectedSets = connectivityInspector.connectedSets();
        Comparator comparator = (set1, set2) -> Integer.compare(set2.size(), set1.size());
        connectedSets.sort(comparator.thenComparing(secondComparator));
        ArrayList<List<V>> finalOrdering = new ArrayList<List<V>>();
        for (Set connectedSet : connectedSets) {
            AsSubgraph connectedSubgraph = new AsSubgraph(this.graph, connectedSet);
            CycleDetector cycleDetector = new CycleDetector((Graph)connectedSubgraph);
            if (cycleDetector.detectCycles()) {
                boolean cyclesLeft = true;
                do {
                    List firstCycle;
                    DefaultWeightedEdge minWeightEdge;
                    JohnsonSimpleCycles cycleFinder = new JohnsonSimpleCycles((Graph)connectedSubgraph);
                    ArrayList<List> cycles = new ArrayList<List>();
                    try {
                        cycleFinder.findSimpleCycles(c -> {
                            cycles.add((List)c);
                            if (cycles.size() >= 100) {
                                throw CycleSearchStopException.INSTANCE;
                            }
                        });
                        cyclesLeft = false;
                    }
                    catch (CycleSearchStopException cycleSearchStopException) {
                        // empty catch block
                    }
                    while (!cycles.isEmpty() && (minWeightEdge = this.findMinWeightEdge((Graph<V, DefaultWeightedEdge>)connectedSubgraph, firstCycle = (List)cycles.get(0))) != null) {
                        Object source = connectedSubgraph.getEdgeSource((Object)minWeightEdge);
                        Object target = connectedSubgraph.getEdgeTarget((Object)minWeightEdge);
                        connectedSubgraph.removeEdge((Object)minWeightEdge);
                        cycles.remove(0);
                        cycles.removeIf(cycle -> this.cycleContainsEdge((V)source, (V)target, (List<V>)cycle));
                    }
                } while (cyclesLeft);
            }
            TopologicalOrderIterator topologicalOrderIterator = new TopologicalOrderIterator((Graph)connectedSubgraph);
            ArrayList<Object> subgroupOrdering = new ArrayList<Object>();
            finalOrdering.add(subgroupOrdering);
            while (topologicalOrderIterator.hasNext()) {
                Object node = topologicalOrderIterator.next();
                subgroupOrdering.add(node);
            }
        }
        return finalOrdering;
    }

    private boolean cycleContainsEdge(V source, V target, List<V> cycle) {
        int sourceIndex = cycle.indexOf(source);
        if (sourceIndex == -1) {
            return false;
        }
        int targetIndex = (sourceIndex + 1) % cycle.size();
        return target.equals(cycle.get(targetIndex));
    }

    private DefaultWeightedEdge findMinWeightEdge(Graph<V, DefaultWeightedEdge> graph, List<V> cycle) {
        double minWeight = Double.MAX_VALUE;
        DefaultWeightedEdge minWeightEdge = null;
        for (int i = 0; i < cycle.size(); ++i) {
            V target;
            V source = cycle.get(i);
            DefaultWeightedEdge edge = (DefaultWeightedEdge)graph.getEdge(source, target = cycle.get((i + 1) % cycle.size()));
            if (edge == null || !(graph.getEdgeWeight((Object)edge) < minWeight)) continue;
            minWeight = graph.getEdgeWeight((Object)edge);
            minWeightEdge = edge;
        }
        return minWeightEdge;
    }

    private static class CycleSearchStopException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        static final CycleSearchStopException INSTANCE = new CycleSearchStopException();

        private CycleSearchStopException() {
        }
    }
}

