/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.ioca;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.afp.ioca.ImageSizeParameter;
import org.apache.fop.afp.modca.AbstractAFPObject;

public class TransparencyMask
extends AbstractAFPObject {
    private static final int MAX_DATA_LEN = 8188;
    private ImageSizeParameter imageSizeParameter;
    private byte[] maskData;

    public TransparencyMask(byte[] maskData, ImageSizeParameter imageSizeParameter) {
        this.maskData = maskData;
        this.imageSizeParameter = imageSizeParameter;
    }

    @Override
    public void writeToStream(OutputStream os) throws IOException {
        os.write(142);
        os.write(0);
        this.imageSizeParameter.writeToStream(os);
        os.write(this.getImageEncodingParameter());
        byte[] dataHeader = new byte[]{-2, -110, 0, 0};
        int lengthOffset = 2;
        TransparencyMask.writeChunksToStream(this.maskData, dataHeader, 2, 8188, os);
        os.write(143);
        os.write(0);
    }

    private byte[] getImageEncodingParameter() {
        byte encoding = 3;
        return new byte[]{-107, 2, encoding, 1};
    }
}

