/*
 * Decompiled with CFR 0.152.
 */
package com.ceph.fs;

import com.ceph.fs.CephMount;
import java.io.FileNotFoundException;
import java.util.UUID;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class CephMountCreateTest {
    private static String conf_file;

    @BeforeClass
    public static void class_setup() throws Exception {
        conf_file = System.getProperty("CEPH_CONF_FILE");
    }

    private CephMount setupMount(String string) throws Exception {
        CephMount cephMount = new CephMount("admin");
        if (conf_file != null) {
            cephMount.conf_read_file(conf_file);
        }
        cephMount.conf_set("client_permissions", "0");
        cephMount.mount(string);
        return cephMount;
    }

    @Test
    public void test_CephMountCreate() throws Exception {
        String string = "libcephfs_junit_" + UUID.randomUUID();
        CephMount cephMount = this.setupMount("/");
        try {
            cephMount.rmdir("/" + string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        cephMount.mkdirs("/" + string, 777);
        String[] stringArray = cephMount.listdir("/");
        boolean bl = false;
        for (String string2 : stringArray) {
            if (string2.compareTo(string) != 0) continue;
            bl = true;
        }
        Assert.assertTrue((boolean)bl);
        cephMount.unmount();
        cephMount = this.setupMount("/" + string);
        stringArray = cephMount.listdir("/");
        bl = false;
        for (String string2 : stringArray) {
            bl = true;
        }
        Assert.assertFalse((boolean)bl);
        cephMount.unmount();
        cephMount = this.setupMount("/");
        cephMount.rmdir("/" + string);
        cephMount.unmount();
    }
}

