/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.MutationEvent;

public class SVGGElementBridge
extends AbstractGraphicsNodeBridge {
    @Override
    public String getLocalName() {
        return "g";
    }

    @Override
    public Bridge getInstance() {
        return new SVGGElementBridge();
    }

    @Override
    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        Rectangle2D rectangle2D;
        CompositeGraphicsNode compositeGraphicsNode = (CompositeGraphicsNode)super.createGraphicsNode(bridgeContext, element);
        if (compositeGraphicsNode == null) {
            return null;
        }
        this.associateSVGContext(bridgeContext, element, (GraphicsNode)compositeGraphicsNode);
        RenderingHints renderingHints = null;
        renderingHints = CSSUtilities.convertColorRendering(element, renderingHints);
        if (renderingHints != null) {
            compositeGraphicsNode.setRenderingHints(renderingHints);
        }
        if ((rectangle2D = CSSUtilities.convertEnableBackground(element)) != null) {
            compositeGraphicsNode.setBackgroundEnable(rectangle2D);
        }
        return compositeGraphicsNode;
    }

    @Override
    protected GraphicsNode instantiateGraphicsNode() {
        return new CompositeGraphicsNode();
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public void handleDOMNodeInsertedEvent(MutationEvent mutationEvent) {
        if (mutationEvent.getTarget() instanceof Element) {
            this.handleElementAdded((CompositeGraphicsNode)this.node, this.e, (Element)((Object)mutationEvent.getTarget()));
        } else {
            super.handleDOMNodeInsertedEvent(mutationEvent);
        }
    }

    protected void handleElementAdded(CompositeGraphicsNode compositeGraphicsNode, Node node, Element element) {
        GVTBuilder gVTBuilder = this.ctx.getGVTBuilder();
        GraphicsNode graphicsNode = gVTBuilder.build(this.ctx, element);
        if (graphicsNode == null) {
            return;
        }
        int n = -1;
        for (Node node2 = element.getPreviousSibling(); node2 != null; node2 = node2.getPreviousSibling()) {
            GraphicsNode graphicsNode2;
            if (node2.getNodeType() != 1) continue;
            Element element2 = (Element)node2;
            for (graphicsNode2 = this.ctx.getGraphicsNode(element2); graphicsNode2 != null && graphicsNode2.getParent() != compositeGraphicsNode; graphicsNode2 = graphicsNode2.getParent()) {
            }
            if (graphicsNode2 != null && (n = compositeGraphicsNode.indexOf((Object)graphicsNode2)) != -1) break;
        }
        compositeGraphicsNode.add(++n, (Object)graphicsNode);
    }
}

